/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.client;

import io.naradrama.prologue.domain.cqrs.DomainMessage;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.domain.cqrs.command.CommandResponse;
import java.sql.Timestamp;

public abstract class CqrsClient
extends DomainMessage {
    private long requestTime = System.currentTimeMillis();
    private long waitingTime;
    private boolean requestFailed;
    private FailureMessage failureMessage;
    private CommandResponse commandResponse;

    public CqrsClient() {
        super(DomainMessageType.CqrsClient);
    }

    public CqrsClient(TraceHeader traceHeader) {
        super(traceHeader, DomainMessageType.CqrsClient);
    }

    public void setCommandResponse(CommandResponse commandResponse) {
        this.commandResponse = commandResponse;
        this.checkWaitingTime();
    }

    public String genRequestTimestamp() {
        return new Timestamp(this.requestTime).toString();
    }

    public void setFailureMessage(FailureMessage failureMessage) {
        this.failureMessage = failureMessage;
        this.checkWaitingTime();
        this.requestFailed = true;
    }

    public FailureMessage getFailureMessage() {
        return this.failureMessage;
    }

    private void checkWaitingTime() {
        this.waitingTime = System.currentTimeMillis() - this.requestTime;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public boolean isRequestFailed() {
        return this.requestFailed;
    }

    public CommandResponse getCommandResponse() {
        return this.commandResponse;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public void setRequestFailed(boolean requestFailed) {
        this.requestFailed = requestFailed;
    }
}

