/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.broker;

import io.naradrama.prologue.domain.cqrs.DomainMessage;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.broker.AbstractStreamEventMessage;
import io.naradrama.prologue.domain.cqrs.query.CqrsQuery;
import io.naradrama.prologue.domain.cqrs.query.SampleCustomerBaseQuery;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Optional;

public class StreamEventMessage
extends AbstractStreamEventMessage {
    private String payloadClass;
    private String payload;
    private String serviceName;

    public StreamEventMessage(DomainMessage domainMessage) {
        super(domainMessage);
        this.payloadClass = domainMessage.toPayloadClassName();
        this.payload = domainMessage.getDomainMessageType().equals((Object)DomainMessageType.CqrsQuery) ? ((CqrsQuery)domainMessage).toJsonWithoutResult() : domainMessage.toPayload();
        Optional.ofNullable(domainMessage.getTraceHeader()).ifPresent(traceHeader -> {
            this.serviceName = traceHeader.getService();
        });
    }

    public String toString() {
        return this.toJson();
    }

    public static StreamEventMessage fromJson(String json) {
        return JsonUtil.fromJson(json, StreamEventMessage.class);
    }

    public <T> boolean equalsPayloadName(Class<T> clazz) {
        return this.payloadClass.equals(clazz.getName());
    }

    public <T> T payloadObject(Class<T> clazz) {
        return JsonUtil.fromJson(this.payload, clazz);
    }

    public Object payloadObject() {
        try {
            return JsonUtil.fromJson(this.payload, Class.forName(this.payloadClass));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't make payload object --> " + this.payloadClass, e);
        }
    }

    public static StreamEventMessage sample() {
        return new StreamEventMessage(SampleCustomerBaseQuery.sample());
    }

    public static void main(String[] args) {
        StreamEventMessage streamEventMessage = StreamEventMessage.sample();
        System.out.println(streamEventMessage.toPrettyJson());
        SampleCustomerBaseQuery sampleQuery = streamEventMessage.payloadObject(SampleCustomerBaseQuery.class);
        System.out.println(sampleQuery.toPrettyJson());
    }

    public String getPayloadClass() {
        return this.payloadClass;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setPayloadClass(String payloadClass) {
        this.payloadClass = payloadClass;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public StreamEventMessage() {
    }
}

