/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs;

import io.naradrama.prologue.domain.stage.ActorKey;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.UUID;

public class TraceHeader
implements JsonSerializable {
    private String traceId;
    private String userId;
    private String parentService;
    private String service;
    private String parentMessage;
    private String message;
    private long time;

    public TraceHeader(String userId) {
        this.traceId = UUID.randomUUID().toString();
        this.userId = userId;
        this.time = System.currentTimeMillis();
    }

    public TraceHeader(TraceHeader parentHeader, String service, String message) {
        this.traceId = parentHeader.getTraceId();
        this.userId = parentHeader.getUserId();
        this.parentService = parentHeader.getService();
        this.parentMessage = parentHeader.getMessage();
        this.service = service;
        this.message = message;
        this.time = System.currentTimeMillis();
    }

    public TraceHeader(TraceHeader traceHeader) {
        this(traceHeader, null, null);
    }

    public String toString() {
        return this.toJson();
    }

    public static TraceHeader fromJson(String json) {
        return JsonUtil.fromJson(json, TraceHeader.class);
    }

    public static TraceHeader sample() {
        TraceHeader sample = new TraceHeader(ActorKey.sample().getId());
        sample.setService("io.naradrama.timecard");
        sample.setMessage("LeaveCommand");
        return TraceHeader.sample();
    }

    public static void main(String[] args) {
        System.out.println(TraceHeader.sample().toPrettyJson());
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getParentService() {
        return this.parentService;
    }

    public String getService() {
        return this.service;
    }

    public String getParentMessage() {
        return this.parentMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTime() {
        return this.time;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setParentService(String parentService) {
        this.parentService = parentService;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setParentMessage(String parentMessage) {
        this.parentMessage = parentMessage;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public TraceHeader() {
    }

    public TraceHeader(String traceId, String userId, String parentService, String service, String parentMessage, String message, long time) {
        this.traceId = traceId;
        this.userId = userId;
        this.parentService = parentService;
        this.service = service;
        this.parentMessage = parentMessage;
        this.message = message;
        this.time = time;
    }
}

