/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs;

import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.util.json.JsonSerializable;
import java.util.UUID;

public abstract class DomainMessage
implements JsonSerializable {
    private String id = UUID.randomUUID().toString();
    private DomainMessageType domainMessageType;
    private TraceHeader traceHeader;

    protected DomainMessage() {
    }

    protected DomainMessage(DomainMessageType domainMessageType) {
        this();
        this.domainMessageType = domainMessageType;
    }

    public DomainMessage(TraceHeader traceHeader, DomainMessageType domainMessageType) {
        this(domainMessageType);
        this.traceHeader = traceHeader;
    }

    public DomainMessage(String id, TraceHeader traceHeader, DomainMessageType domainMessageType) {
        this(domainMessageType);
        this.id = id;
        this.traceHeader = traceHeader;
    }

    public String toPayload() {
        return this.toJson();
    }

    public String toPayloadClassName() {
        return this.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public DomainMessageType getDomainMessageType() {
        return this.domainMessageType;
    }

    public TraceHeader getTraceHeader() {
        return this.traceHeader;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDomainMessageType(DomainMessageType domainMessageType) {
        this.domainMessageType = domainMessageType;
    }

    public void setTraceHeader(TraceHeader traceHeader) {
        this.traceHeader = traceHeader;
    }
}

