/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimePeriod
implements JsonSerializable {
    private static String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private String zoneId;
    private LocalTime startTime;
    private LocalTime endTime;

    public TimePeriod() {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startTime = LocalTime.now();
        this.endTime = null;
    }

    public TimePeriod(ZonedDateTime startTime, ZonedDateTime endTime) {
        this.zoneId = startTime.getZone().getId();
        this.startTime = startTime.toLocalTime();
        this.endTime = endTime.toLocalTime();
    }

    public TimePeriod(LocalTime startTime, LocalTime endTime) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String toString() {
        return this.toJson();
    }

    public String toSimpleString() {
        return String.format("StartTime[%s], EndTime[%s]", this.startTime.toString(), this.endTime.toString());
    }

    public static TimePeriod fromJson(String json) {
        return JsonUtil.fromJson(json, TimePeriod.class);
    }

    public static TimePeriod sample() {
        return new TimePeriod(LocalTime.now(), LocalTime.now().plusHours(2L));
    }

    public static void main(String[] args) {
        System.out.println(TimePeriod.sample().toPrettyJson());
        System.out.println(TimePeriod.sample().toSimpleString());
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public TimePeriod(String zoneId, LocalTime startTime, LocalTime endTime) {
        this.zoneId = zoneId;
        this.startTime = startTime;
        this.endTime = endTime;
    }
}

