/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class StringList
implements JsonSerializable {
    private List<String> elements;

    public StringList() {
        this.elements = new ArrayList<String>();
    }

    public StringList(int capacity) {
        this.elements = new ArrayList<String>(capacity);
    }

    public String toString() {
        return this.toJson();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public static StringList fromJson(String json) {
        return JsonUtil.fromJson(json, StringList.class);
    }

    public static StringList newInstance(String element) {
        StringList stringList = new StringList();
        stringList.getElements().add(element);
        return stringList;
    }

    public static StringList newInstance(String ... elements) {
        StringList stringList = new StringList(elements.length);
        for (String element : elements) {
            stringList.getElements().add(element);
        }
        return stringList;
    }

    public StringList add(String element) {
        this.elements.add(element);
        return this;
    }

    public boolean contains(String element) {
        return this.elements.contains(element);
    }

    public int size() {
        return this.elements.size();
    }

    public String get(int index) {
        return this.elements.get(index);
    }

    public static StringList sample() {
        return StringList.newInstance("Morning", "Afternoon", "Evening");
    }

    public static void main(String[] args) {
        System.out.println(StringList.sample().toPrettyJson());
        System.out.println(StringList.sample().isEmpty());
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setElements(List<String> elements) {
        this.elements = elements;
    }
}

