/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.domain.NameValue;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class NameValueList
implements JsonSerializable {
    private List<NameValue> nameValues = new ArrayList<NameValue>();

    public NameValueList() {
    }

    public NameValueList(NameValue nameValue) {
        this();
        this.nameValues.add(nameValue);
    }

    public NameValueList(String name, String value) {
        this();
        this.nameValues.add(new NameValue(name, value));
    }

    public NameValueList(NameValueList nameValues) {
        this();
        this.nameValues.addAll(nameValues.list());
    }

    public static NameValueList newInstance(String name, String value) {
        return new NameValueList(name, value);
    }

    public static NameValueList newEmptyInstance() {
        return new NameValueList();
    }

    public String toString() {
        return this.toJson();
    }

    public static NameValueList sample() {
        return new NameValueList("name", "Cheolsoo Kim");
    }

    public static NameValueList fromJson(String json) {
        return JsonUtil.fromJson(json, NameValueList.class);
    }

    public NameValueList add(NameValue nameValue) {
        this.nameValues.add(nameValue);
        return this;
    }

    public NameValueList addAll(NameValueList nameValues) {
        this.nameValues.addAll(nameValues.list());
        return this;
    }

    public NameValueList add(String name, String value) {
        this.nameValues.add(new NameValue(name, value));
        return this;
    }

    public NameValueList remove(String name) {
        NameValue targetNameValue = null;
        for (NameValue nameValue : this.nameValues) {
            if (!nameValue.getName().equals(name)) continue;
            targetNameValue = nameValue;
            break;
        }
        if (targetNameValue != null) {
            this.nameValues.remove(targetNameValue);
        }
        return this;
    }

    public String getValueOf(String name) {
        return this.getNameValue(name).getValue();
    }

    public NameValue getNameValue(String name) {
        return this.nameValues.stream().filter(nameValue -> name.equals(nameValue.getName())).findFirst().orElse(null);
    }

    public void addAll(List<NameValue> nameValues) {
        this.nameValues.addAll(nameValues);
    }

    public List<NameValue> list() {
        return this.nameValues;
    }

    public boolean containsName(String name) {
        return this.nameValues.stream().anyMatch(nv -> nv.getName().equals(name));
    }

    public int size() {
        return this.nameValues.size();
    }

    public static void main(String[] args) {
        System.out.println(NameValueList.sample());
    }

    public List<NameValue> getNameValues() {
        return this.nameValues;
    }

    public void setNameValues(List<NameValue> nameValues) {
        this.nameValues = nameValues;
    }
}

