/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.StringTokenizer;

public class LongPair
implements JsonSerializable {
    private static final String PAIR_TOKEN = ":";
    private long left;
    private long right;

    public LongPair(long left, long right) {
        this.left = left;
        this.right = right;
    }

    public LongPair(long left) {
        this.left = left;
        this.right = 0L;
    }

    public LongPair(String pairString) {
        StringTokenizer tokenizer = new StringTokenizer(pairString, PAIR_TOKEN);
        this.left = Long.parseLong(tokenizer.nextToken());
        this.right = Long.parseLong(tokenizer.nextToken());
    }

    public String toString() {
        return this.toJson();
    }

    public static LongPair fromJson(String json) {
        return JsonUtil.fromJson(json, LongPair.class);
    }

    public String toSimpleString() {
        return String.format("%d:%d", this.left, this.right);
    }

    public void increaseLeft() {
        ++this.left;
    }

    public void increaseRight() {
        ++this.right;
    }

    public void decreaseLeft() {
        --this.left;
    }

    public void decreaseRight() {
        --this.right;
    }

    public static LongPair sample() {
        return new LongPair("3:5");
    }

    public static void main(String[] args) {
        System.out.println(LongPair.sample());
    }

    public long getLeft() {
        return this.left;
    }

    public long getRight() {
        return this.right;
    }

    public void setLeft(long left) {
        this.left = left;
    }

    public void setRight(long right) {
        this.right = right;
    }

    public LongPair() {
    }
}

