/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.StringTokenizer;

public class IntPair
implements JsonSerializable {
    private static final String PAIR_TOKEN = ":";
    private int left;
    private int right;

    public IntPair(String pairString) {
        StringTokenizer tokenizer = new StringTokenizer(pairString, PAIR_TOKEN);
        this.left = Integer.parseInt(tokenizer.nextToken());
        this.right = Integer.parseInt(tokenizer.nextToken());
    }

    public String toString() {
        return this.toJson();
    }

    public static IntPair fromJson(String json) {
        return JsonUtil.fromJson(json, IntPair.class);
    }

    public String toSimpleString() {
        return String.format("%d:%d", this.left, this.right);
    }

    public void increaseLeft() {
        ++this.left;
    }

    public void increaseRight() {
        ++this.right;
    }

    public void decreaseLeft() {
        --this.left;
    }

    public void decreaseRight() {
        --this.right;
    }

    public static IntPair sample() {
        return new IntPair("3:5");
    }

    public static void main(String[] args) {
        System.out.println(IntPair.sample());
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public IntPair() {
    }

    public IntPair(int left, int right) {
        this.left = left;
        this.right = right;
    }
}

