/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.domain.IdName;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class IdNameList
implements JsonSerializable,
Serializable {
    private List<IdName> idNames;

    public IdNameList(int capacity) {
        this.idNames = new ArrayList<IdName>(capacity);
    }

    public IdNameList() {
        this.idNames = new ArrayList<IdName>();
    }

    public IdNameList(IdName idName) {
        this();
        this.idNames.add(idName);
    }

    public IdNameList(String id, String name) {
        this();
        this.idNames.add(new IdName(id, name));
    }

    public IdNameList(List<IdName> idNames) {
        this.idNames = idNames;
    }

    public String toString() {
        return this.toJson();
    }

    public static IdNameList fromJson(String json) {
        return JsonUtil.fromJson(json, IdNameList.class);
    }

    public IdNameList add(IdName idName) {
        this.idNames.add(idName);
        return this;
    }

    public IdNameList add(String id, String name) {
        this.idNames.add(new IdName(id, name));
        return this;
    }

    public void addAll(List<IdName> idNames) {
        this.idNames.addAll(idNames);
    }

    public List<IdName> list() {
        return this.idNames;
    }

    public void removeById(String id) {
        for (IdName idName : this.getById(id)) {
            this.idNames.remove(idName);
        }
    }

    public List<IdName> getById(String id) {
        ArrayList<IdName> foundIdNames = new ArrayList<IdName>();
        for (IdName idName : this.idNames) {
            if (!idName.getId().equals(id)) continue;
            foundIdNames.add(idName);
        }
        return foundIdNames;
    }

    public IdName getByNameFirst(String name) {
        for (IdName idName : this.idNames) {
            if (!idName.getName().equals(name)) continue;
            return idName;
        }
        throw new NoSuchElementException("Name: " + name);
    }

    public boolean containsId(String id) {
        for (IdName idName : this.idNames) {
            if (!id.equals(idName.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(String name) {
        for (IdName idName : this.idNames) {
            if (!name.equals(idName.getName())) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.idNames.size();
    }

    public static IdNameList sample() {
        return new IdNameList(IdName.sample());
    }

    public static void main(String[] args) {
        System.out.println(IdNameList.sample());
    }

    public List<IdName> getIdNames() {
        return this.idNames;
    }

    public void setIdNames(List<IdName> idNames) {
        this.idNames = idNames;
    }
}

