/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Objects;
import java.util.StringTokenizer;

public class IdName
implements JsonSerializable {
    private String id;
    private String name;

    public static IdName of(String id, String name) {
        return new IdName(id, name);
    }

    public String toString() {
        return this.toJson();
    }

    public String toSimpleString() {
        return this.id + ":" + this.name;
    }

    public static IdName fromSimpleString(String idNameStr) {
        StringTokenizer tokenizer = new StringTokenizer(idNameStr, ":");
        String id = tokenizer.nextToken();
        String name = tokenizer.nextToken();
        return new IdName(id, name);
    }

    public static IdName fromJson(String json) {
        return JsonUtil.fromJson(json, IdName.class);
    }

    public static IdName sample() {
        String id = "1234";
        String name = "Steve Jobs";
        return new IdName(id, name);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target == null || this.getClass() != target.getClass()) {
            return false;
        }
        IdName idName = (IdName)target;
        return Objects.equals(this.id, idName.id) && Objects.equals(this.name, idName.name);
    }

    public int hashCode() {
        return Objects.hash(this.id + this.name);
    }

    public static void main(String[] args) {
        System.out.println(IdName.sample());
        System.out.println(IdName.fromSimpleString(IdName.sample().toSimpleString()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IdName() {
    }

    public IdName(String id, String name) {
        this.id = id;
        this.name = name;
    }
}

