/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.StringTokenizer;

public class DoublePair
implements JsonSerializable {
    private static final String PAIR_TOKEN = ":";
    private double left;
    private double right;

    public DoublePair(double left, double right) {
        this.left = left;
        this.right = right;
    }

    public DoublePair(double left) {
        this.left = left;
        this.right = 0.0;
    }

    public DoublePair(String pairString) {
        StringTokenizer tokenizer = new StringTokenizer(pairString, PAIR_TOKEN);
        this.left = Double.parseDouble(tokenizer.nextToken());
        this.right = Double.parseDouble(tokenizer.nextToken());
    }

    public String toString() {
        return this.toJson();
    }

    public static DoublePair fromJson(String json) {
        return JsonUtil.fromJson(json, DoublePair.class);
    }

    public String toSimpleString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.left);
        builder.append(PAIR_TOKEN);
        builder.append(this.right);
        return builder.toString();
    }

    public void increaseLeft() {
        this.left += 1.0;
    }

    public void increaseRight() {
        this.right += 1.0;
    }

    public void decreaseLeft() {
        this.left -= 1.0;
    }

    public void decreaseRight() {
        this.right -= 1.0;
    }

    public static DoublePair sample() {
        return new DoublePair("3.1:5.3");
    }

    public static void main(String[] args) {
        System.out.println(DoublePair.sample().toPrettyJson());
        System.out.println(DoublePair.sample().toSimpleString());
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public DoublePair() {
    }
}

