/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class DateTimePeriod
implements JsonSerializable {
    private ZoneId zoneId = ZoneId.systemDefault();
    private LocalDateTime startTime;
    private LocalDateTime endTime;

    public DateTimePeriod(LocalDateTime startTime, LocalDateTime endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String toString() {
        return this.toJson();
    }

    public static DateTimePeriod fromJson(String json) {
        return JsonUtil.fromJson(json, DateTimePeriod.class);
    }

    public String genStartTime() {
        if (this.startTime == null) {
            return "None";
        }
        return this.startTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public String genEndTime() {
        if (this.endTime == null) {
            return "None";
        }
        return this.endTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static DateTimePeriod sample() {
        return new DateTimePeriod(LocalDateTime.now(), LocalDateTime.now().plusDays(5L));
    }

    public static void main(String[] args) {
        System.out.println(DateTimePeriod.sample().toPrettyJson());
        System.out.println(DateTimePeriod.sample().genStartTime());
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public DateTimePeriod() {
    }

    public DateTimePeriod(ZoneId zoneId, LocalDateTime startTime, LocalDateTime endTime) {
        this.zoneId = zoneId;
        this.startTime = startTime;
        this.endTime = endTime;
    }
}

