/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.date.DateFormatUtil;
import io.naradrama.prologue.util.date.DateUtil;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.string.StringUtil;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class DatePeriod
implements JsonSerializable,
Serializable {
    private static final long serialVersionUID = -271823209462009194L;
    private String zoneId;
    private String startDate;
    private String endDate;

    public DatePeriod() {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
        this.endDate = null;
    }

    public DatePeriod(LocalDate startDate) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        this.endDate = null;
    }

    public DatePeriod(LocalDate startDate, LocalDate endDate) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        this.endDate = endDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public DatePeriod(ZoneId zoneId, LocalDate startDate, LocalDate endDate) {
        this(zoneId.getId(), startDate, endDate);
    }

    public DatePeriod(String zoneId, LocalDate startDate, LocalDate endDate) {
        this.zoneId = zoneId;
        this.startDate = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        this.endDate = endDate == null ? null : endDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public DatePeriod(String zoneId, String startDate, String endDate) {
        this.zoneId = zoneId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public DatePeriod(LocalDate startDate, int days) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        this.endDate = startDate.plusDays(days).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public DatePeriod(String startDateStr, int days) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = startDateStr;
        LocalDate start = LocalDate.parse(startDateStr);
        this.endDate = start.plusDays(days).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public DatePeriod(String startDate, String endDate) {
        this.zoneId = ZoneId.systemDefault().getId();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String toString() {
        return this.toJson();
    }

    public long genPeriodDays() {
        LocalDate startDate = this.genStartLocalDate();
        LocalDate endDate = this.genEndLocalDate();
        return ChronoUnit.DAYS.between(startDate, endDate);
    }

    public long genWorkingDays() {
        LocalDate startDate = this.genStartLocalDate();
        long period = this.genPeriodDays() + 1L;
        long workingDays = 0L;
        int i = 0;
        while ((long)i < period) {
            LocalDate targetDate = startDate.plusDays(i);
            if (!this.isWeekend(targetDate)) {
                ++workingDays;
            }
            ++i;
        }
        return workingDays;
    }

    public long genPeriodMonths() {
        LocalDate startDate = this.genStartLocalDate();
        LocalDate endDate = this.genEndLocalDate();
        YearMonth startYearMonth = YearMonth.from(startDate);
        YearMonth endYearMonth = YearMonth.from(endDate);
        return endYearMonth.compareTo(startYearMonth);
    }

    public List<DatePeriod> genDatePeriodsPerMonth() {
        long periodMonths = this.genPeriodMonths();
        ArrayList<DatePeriod> datePeriods = new ArrayList<DatePeriod>();
        if (periodMonths == 0L) {
            datePeriods.add(this);
            return datePeriods;
        }
        DatePeriod periodPerStartMonth = this.genPeriodPerStartMonth();
        datePeriods.add(periodPerStartMonth);
        if (periodMonths > 1L) {
            LocalDate startDate = this.genStartLocalDate();
            int i = 1;
            while ((long)i < periodMonths) {
                LocalDate nextDate = startDate.plusMonths(i);
                DatePeriod periodPerMonth = this.genPeriodPerMonth(nextDate);
                datePeriods.add(periodPerMonth);
                ++i;
            }
        }
        DatePeriod periodPerEndMonth = this.genPeriodPerEndMonth();
        datePeriods.add(periodPerEndMonth);
        return datePeriods;
    }

    private DatePeriod genPeriodPerStartMonth() {
        LocalDate startDate = this.genStartLocalDate();
        LocalDate lastDayOfStartYearMonth = startDate.with(TemporalAdjusters.lastDayOfMonth());
        return new DatePeriod(startDate, lastDayOfStartYearMonth);
    }

    private DatePeriod genPeriodPerEndMonth() {
        LocalDate endDate = this.genEndLocalDate();
        LocalDate firstDayOfEndYearMonth = endDate.with(TemporalAdjusters.firstDayOfMonth());
        return new DatePeriod(firstDayOfEndYearMonth, endDate);
    }

    private DatePeriod genPeriodPerMonth(LocalDate date) {
        LocalDate firstDayOfMonth = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = date.with(TemporalAdjusters.lastDayOfMonth());
        return new DatePeriod(firstDayOfMonth, lastDayOfMonth);
    }

    public boolean isWeekend(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return dayOfWeek.equals(DayOfWeek.SATURDAY) || dayOfWeek.equals(DayOfWeek.SUNDAY);
    }

    public LocalDate genStartLocalDate() {
        return LocalDate.parse(this.startDate);
    }

    public LocalDate genEndLocalDate() {
        if (this.endDate == null) {
            throw new NoSuchElementException("No endDate value.");
        }
        return LocalDate.parse(this.endDate);
    }

    public List<LocalDate> genLocalDateList() {
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>();
        LocalDate date = this.genStartLocalDate();
        long period = this.genPeriodDays();
        int i = 0;
        while ((long)i <= period) {
            localDates.add(date.plusDays(i));
            ++i;
        }
        return localDates;
    }

    public List<LocalDate> genLocalDateListExceptWeekend() {
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>();
        LocalDate date = this.genStartLocalDate();
        long period = this.genPeriodDays();
        int i = 0;
        while ((long)i <= period) {
            LocalDate targetDate = date.plusDays(i);
            if (!this.isWeekend(targetDate)) {
                localDates.add(targetDate);
            }
            ++i;
        }
        return localDates;
    }

    public static DatePeriod sample() {
        return new DatePeriod(LocalDate.now(), 5);
    }

    public int genMonthPeriod() {
        if (!this.hasEndDate()) {
            return 0;
        }
        if (StringUtil.isEmpty((CharSequence)this.startDate) || StringUtil.isEmpty((CharSequence)this.endDate)) {
            return 0;
        }
        LocalDate start = LocalDate.parse(this.startDate);
        LocalDate end = LocalDate.parse(this.endDate);
        Period period = Period.between(start, end);
        return period.getMonths();
    }

    public static DatePeriod fromJson(String json) {
        return JsonUtil.fromJson(json, DatePeriod.class);
    }

    public boolean hasEndDate() {
        return this.endDate != null;
    }

    public int genStartYear() {
        if (this.startDate == null) {
            return 0;
        }
        LocalDate start = LocalDate.parse(this.startDate);
        return start.getYear();
    }

    public int genStartMonthValue() {
        if (this.startDate == null) {
            return 0;
        }
        LocalDate start = LocalDate.parse(this.startDate);
        return start.getMonthValue();
    }

    public int genEndYear() {
        if (this.endDate == null) {
            return 0;
        }
        LocalDate end = LocalDate.parse(this.endDate);
        return end.getYear();
    }

    public int genEndMonthValue() {
        if (this.endDate == null) {
            return 0;
        }
        LocalDate end = LocalDate.parse(this.endDate);
        return end.getMonthValue();
    }

    public boolean contains(LocalDate date) {
        if (!this.hasEndDate()) {
            return false;
        }
        LocalDate start = LocalDate.parse(this.startDate);
        LocalDate end = LocalDate.parse(this.endDate);
        return !(!start.isEqual(date) && !start.isBefore(date) || !end.isEqual(date) && !end.isAfter(date));
    }

    public boolean isValid() {
        if (!ZoneId.getAvailableZoneIds().contains(this.zoneId)) {
            return false;
        }
        try {
            DateUtil.parseDate((String)this.startDate, (String[])new String[]{DateFormatUtil.ISO_DATE_FORMAT.getPattern()});
            DateUtil.parseDate((String)this.endDate, (String[])new String[]{DateFormatUtil.ISO_DATE_FORMAT.getPattern()});
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatePeriod datePeriod = (DatePeriod)o;
        return Objects.equals(this.zoneId, datePeriod.zoneId) && Objects.equals(this.startDate, datePeriod.startDate) && Objects.equals(this.endDate, datePeriod.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.startDate, this.endDate);
    }

    public static void main(String[] args) {
        System.out.println(DatePeriod.sample());
        System.out.println(DatePeriod.sample().genMonthPeriod());
        LocalDate now = LocalDate.now();
        LocalDate yesterday = now.minusDays(1L);
        LocalDate tomorrow = now.plusDays(1L);
        DatePeriod datePeriod = new DatePeriod(ZoneId.systemDefault().getId(), yesterday, tomorrow);
        List<DatePeriod> datePeriods = DatePeriod.sample().genDatePeriodsPerMonth();
        System.out.println(datePeriod);
        System.out.println(datePeriod.genPeriodDays());
        System.out.println(datePeriod.contains(LocalDate.now()));
        System.out.println(datePeriod.contains(LocalDate.now().minusDays(1L)));
        System.out.println(datePeriod.contains(LocalDate.now().minusDays(2L)));
        System.out.println(datePeriod.contains(LocalDate.now().plusDays(1L)));
        System.out.println(datePeriod.contains(LocalDate.now().plusDays(2L)));
        System.out.println(datePeriod.genLocalDateList());
        System.out.println(datePeriods);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}

