/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.domain.CodeName;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class CodeNameList
implements JsonSerializable {
    private List<CodeName> codeNames;

    public CodeNameList(int capacity) {
        this.codeNames = new ArrayList<CodeName>(capacity);
    }

    public CodeNameList() {
        this.codeNames = new ArrayList<CodeName>();
    }

    public CodeNameList(CodeName codeName) {
        this();
        this.codeNames.add(codeName);
    }

    public CodeNameList(String code, String name) {
        this();
        this.codeNames.add(new CodeName(code, name));
    }

    public CodeNameList(List<CodeName> codeNames) {
        this.codeNames = codeNames;
    }

    public static CodeNameList newInstance(String code, String name) {
        return new CodeNameList(code, name);
    }

    public String toString() {
        return this.toJson();
    }

    public static CodeNameList fromJson(String json) {
        return JsonUtil.fromJson(json, CodeNameList.class);
    }

    public CodeNameList add(CodeName codeName) {
        this.codeNames.add(codeName);
        return this;
    }

    public CodeNameList add(String code, String name) {
        this.codeNames.add(new CodeName(code, name));
        return this;
    }

    public void addAll(List<CodeName> codeNames) {
        this.codeNames.addAll(codeNames);
    }

    public List<CodeName> list() {
        return this.codeNames;
    }

    public void removeByCode(String code) {
        for (CodeName codeName : this.getByCode(code)) {
            this.codeNames.remove(codeName);
        }
    }

    public List<CodeName> getByCode(String id) {
        ArrayList<CodeName> foundIdNames = new ArrayList<CodeName>();
        for (CodeName codeName : this.codeNames) {
            if (!codeName.getCode().equals(id)) continue;
            foundIdNames.add(codeName);
        }
        return foundIdNames;
    }

    public int size() {
        return this.codeNames.size();
    }

    public static CodeNameList sample() {
        return new CodeNameList(CodeName.sample());
    }

    public static void main(String[] args) {
        System.out.println(CodeNameList.sample());
    }

    public List<CodeName> getCodeNames() {
        return this.codeNames;
    }

    public void setCodeNames(List<CodeName> codeNames) {
        this.codeNames = codeNames;
    }
}

