/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Objects;
import java.util.StringTokenizer;

public class CodeName
implements ValueObject {
    private String code;
    private String name;

    public String toString() {
        return this.toJson();
    }

    public String toSimpleString() {
        return this.code + ":" + this.name;
    }

    public static CodeName fromSimpleString(String codeNameStr) {
        StringTokenizer tokenizer = new StringTokenizer(codeNameStr, ":");
        String code = tokenizer.nextToken();
        String name = tokenizer.nextToken();
        return new CodeName(code, name);
    }

    public static CodeName fromJson(String json) {
        return JsonUtil.fromJson(json, CodeName.class);
    }

    public static CodeName sample() {
        String code = "1234";
        String name = "NEXTREE";
        return new CodeName(code, name);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target == null || this.getClass() != target.getClass()) {
            return false;
        }
        CodeName idName = (CodeName)target;
        return Objects.equals(this.code, idName.code) && Objects.equals(this.name, idName.name);
    }

    public int hashCode() {
        return Objects.hash(this.code + this.name);
    }

    public static void main(String[] args) {
        System.out.println(CodeName.sample());
        System.out.println(CodeName.fromSimpleString(CodeName.sample().toSimpleString()));
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CodeName() {
    }

    public CodeName(String code, String name) {
        this.code = code;
        this.name = name;
    }
}

