/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.domain.BriefTime;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;

public class BriefTimePeriod
implements JsonSerializable {
    private BriefTime startTime;
    private BriefTime endTime;

    public BriefTimePeriod(BriefTime startTime, BriefTime endTime) {
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("startTime and endTime should not be null");
        }
        if (endTime.before(startTime)) {
            throw new IllegalArgumentException("startTime should be before the endTime.");
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String toString() {
        return this.toJson();
    }

    public String toSimpleString() {
        return this.startTime.toSimpleString() + "-" + this.endTime.toSimpleString();
    }

    public static BriefTimePeriod fromJson(String json) {
        return JsonUtil.fromJson(json, BriefTimePeriod.class);
    }

    public static BriefTimePeriod sample() {
        return new BriefTimePeriod(new BriefTime(10, 30), new BriefTime(11, 30));
    }

    public int periodAsMinute() {
        return this.endTime.asMinute() - this.startTime.asMinute();
    }

    public BriefTime period() {
        return new BriefTime(this.periodAsMinute());
    }

    public static void main(String[] args) {
        System.out.println(BriefTimePeriod.sample().toSimpleString());
        System.out.println(BriefTimePeriod.sample().period().toSimpleString());
    }

    public BriefTime getStartTime() {
        return this.startTime;
    }

    public BriefTime getEndTime() {
        return this.endTime;
    }

    public void setStartTime(BriefTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(BriefTime endTime) {
        this.endTime = endTime;
    }

    public BriefTimePeriod() {
    }
}

