/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.time.LocalTime;

public class BriefTime
implements JsonSerializable {
    private int hour;
    private int minute;

    public BriefTime(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour should be between 0 with 23: " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute should be between 0 with 59: " + minute);
        }
        this.hour = hour;
        this.minute = minute;
    }

    public BriefTime(int minute) {
        this.hour = minute / 60;
        this.minute = minute % 60;
    }

    public String toString() {
        return this.toJson();
    }

    public String toSimpleString() {
        return String.format("%02d:%02d", this.hour, this.minute);
    }

    public static BriefTime of(int hour, int minute) {
        return new BriefTime(hour, minute);
    }

    public static BriefTime ofHour(int hour) {
        return new BriefTime(hour, 0);
    }

    public static BriefTime ofMinute(int minute) {
        return new BriefTime(minute);
    }

    public static BriefTime now() {
        LocalTime now = LocalTime.now();
        return new BriefTime(now.getHour(), now.getMinute());
    }

    public static BriefTime withMinutes(int minutes) {
        return new BriefTime(minutes);
    }

    public boolean equals(BriefTime briefTime) {
        return this.hour == briefTime.getHour() && this.minute == briefTime.getMinute();
    }

    public boolean before(BriefTime targetTime) {
        if (this.hour < targetTime.getHour()) {
            return true;
        }
        if (this.hour == targetTime.getHour()) {
            return this.minute < targetTime.getMinute();
        }
        return false;
    }

    public boolean after(BriefTime briefTime) {
        if (this.hour > briefTime.getHour()) {
            return true;
        }
        return this.minute > briefTime.getMinute();
    }

    public boolean between(BriefTime startTime, BriefTime endTime) {
        return this.after(startTime) && this.before(endTime);
    }

    public static BriefTime fromJson(String json) {
        return JsonUtil.fromJson(json, BriefTime.class);
    }

    public static BriefTime sample() {
        return new BriefTime(10, 30);
    }

    public void addMinute(int minute) {
        this.minute += minute;
    }

    public int asMinute() {
        return this.hour * 60 + this.minute;
    }

    public void addHour(int hour) {
        this.hour += hour;
    }

    public int periodAsMinute(BriefTime targetTime) {
        return (targetTime.getHour() - this.hour) * 60 + (targetTime.getMinute() - this.minute);
    }

    public BriefTime period(BriefTime targetTime) {
        return BriefTime.withMinutes(this.periodAsMinute(targetTime));
    }

    public static void main(String[] args) {
        BriefTime now = BriefTime.now();
        BriefTime later30 = BriefTime.now();
        later30.addMinute(30);
        BriefTime later20 = BriefTime.now();
        later20.addMinute(20);
        System.out.println(now.equals(now));
        System.out.println(now.before(later30));
        System.out.println(later30.after(now));
        System.out.println(later20.between(now, later30));
        System.out.println(now.after(now));
        System.out.println(now.before(now));
        System.out.println(now.periodAsMinute(later20));
        System.out.println(later20.periodAsMinute(now));
        System.out.println(now.period(later20).toPrettyJson());
        System.out.println(BriefTime.withMinutes(70).toPrettyJson());
        BriefTime exception = new BriefTime(44, 44);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public BriefTime() {
    }
}

