/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import io.muserver.MuHandlerBuilder;
import io.muserver.Mutils;
import io.muserver.murp.HttpClientUtils;
import io.muserver.murp.ProxyCompleteListener;
import io.muserver.murp.RequestInterceptor;
import io.muserver.murp.ResponseInterceptor;
import io.muserver.murp.ReverseProxy;
import io.muserver.murp.UriMapper;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyBuilder
implements MuHandlerBuilder<ReverseProxy> {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyBuilder.class);
    private String viaName = "private";
    private HttpClient httpClient;
    private UriMapper uriMapper;
    private boolean sendLegacyForwardedHeaders;
    private boolean discardClientForwardedHeaders;
    private long totalTimeoutInMillis = TimeUnit.MINUTES.toMillis(5L);
    private List<ProxyCompleteListener> proxyCompleteListeners;
    private final Set<String> doNotProxyHeaders = new HashSet<String>();
    private RequestInterceptor requestInterceptor;
    private ResponseInterceptor responseInterceptor;

    private ReverseProxyBuilder() {
    }

    public ReverseProxyBuilder withViaName(String viaName) {
        Mutils.notNull((String)"viaName", (Object)viaName);
        this.viaName = viaName;
        return this;
    }

    public ReverseProxyBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public static HttpClient.Builder createHttpClientBuilder(boolean trustAll) {
        return HttpClientUtils.createHttpClientBuilder(trustAll).followRedirects(HttpClient.Redirect.NEVER);
    }

    public ReverseProxyBuilder withUriMapper(UriMapper uriMapper) {
        this.uriMapper = uriMapper;
        return this;
    }

    public ReverseProxyBuilder sendLegacyForwardedHeaders(boolean sendLegacyForwardedHeaders) {
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        return this;
    }

    public ReverseProxyBuilder proxyHostHeader(boolean sendHostToTarget) {
        if (sendHostToTarget) {
            if (HttpClientUtils.DISALLOWED_REQUEST_HEADERS.contains("host")) {
                throw new IllegalStateException("Host header is not allowed to be set in JDK HTTP client at your current JDK version, please try upgrading to JDK 17 or higher.");
            }
            this.doNotProxyHeaders.remove("host");
        } else {
            this.doNotProxyHeaders.add("host");
        }
        return this;
    }

    public ReverseProxyBuilder discardClientForwardedHeaders(boolean discardClientForwardedHeaders) {
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        return this;
    }

    public ReverseProxyBuilder withTotalTimeout(long totalTimeoutInMillis) {
        this.totalTimeoutInMillis = totalTimeoutInMillis;
        return this;
    }

    public ReverseProxyBuilder withTotalTimeout(long totalTimeout, TimeUnit unit) {
        return this.withTotalTimeout(unit.toMillis(totalTimeout));
    }

    public ReverseProxyBuilder addProxyCompleteListener(ProxyCompleteListener proxyCompleteListener) {
        if (this.proxyCompleteListeners == null) {
            this.proxyCompleteListeners = new ArrayList<ProxyCompleteListener>(1);
        }
        this.proxyCompleteListeners.add(proxyCompleteListener);
        return this;
    }

    public ReverseProxyBuilder withRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
        return this;
    }

    public ReverseProxyBuilder withResponseInterceptor(ResponseInterceptor responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
        return this;
    }

    public static ReverseProxyBuilder reverseProxy() {
        return new ReverseProxyBuilder();
    }

    public ReverseProxy build() {
        List<ProxyCompleteListener> proxyCompleteListeners;
        if (this.uriMapper == null) {
            throw new IllegalStateException("A URI mapper must be specified");
        }
        HttpClient client = this.httpClient;
        if (client == null) {
            client = ReverseProxyBuilder.createHttpClientBuilder(true).build();
        }
        if ((proxyCompleteListeners = this.proxyCompleteListeners) == null) {
            proxyCompleteListeners = Collections.emptyList();
        }
        HashSet<Object> notProxyHeaders = new HashSet<Object>(){
            {
                this.addAll(HttpClientUtils.DISALLOWED_REQUEST_HEADERS);
                this.addAll(ReverseProxyBuilder.this.doNotProxyHeaders);
                this.remove("content-length");
            }
        };
        log.warn("these headers will not be proxied: {}", notProxyHeaders.stream().sorted().collect(Collectors.toList()));
        return new ReverseProxy(client, this.uriMapper, this.totalTimeoutInMillis, proxyCompleteListeners, this.viaName, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.doNotProxyHeaders, this.requestInterceptor, this.responseInterceptor);
    }
}

