/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import io.muserver.AsyncHandle;
import io.muserver.DoneCallback;
import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.RequestBodyListener;
import io.muserver.murp.HttpClientUtils;
import io.muserver.murp.ProxyCompleteListener;
import io.muserver.murp.RequestInterceptor;
import io.muserver.murp.ResponseInterceptor;
import io.muserver.murp.UriMapper;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxy
implements MuHandler {
    private static final Logger log;
    public static final Set<String> HOP_BY_HOP_HEADERS;
    private static final Set<String> REPRESSED;
    private final AtomicLong counter = new AtomicLong();
    private final HttpClient httpClient;
    private final UriMapper uriMapper;
    private final long totalTimeoutInMillis;
    private final List<ProxyCompleteListener> proxyCompleteListeners;
    private final Set<String> doNotProxyToTarget = new HashSet<String>();
    private static final String ipAddress;
    private final String viaName;
    private final boolean discardClientForwardedHeaders;
    private final boolean sendLegacyForwardedHeaders;
    private final RequestInterceptor requestInterceptor;
    private final ResponseInterceptor responseInterceptor;

    ReverseProxy(HttpClient httpClient, UriMapper uriMapper, long totalTimeoutInMillis, List<ProxyCompleteListener> proxyCompleteListeners, String viaName, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, Set<String> additionalDoNotProxyHeaders, RequestInterceptor requestInterceptor, ResponseInterceptor responseInterceptor) {
        this.httpClient = httpClient;
        this.uriMapper = uriMapper;
        this.totalTimeoutInMillis = totalTimeoutInMillis;
        this.proxyCompleteListeners = proxyCompleteListeners;
        this.viaName = viaName;
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.doNotProxyToTarget.addAll(REPRESSED);
        additionalDoNotProxyHeaders.forEach(h -> this.doNotProxyToTarget.add(h.toLowerCase()));
    }

    public boolean handle(final MuRequest clientRequest, final MuResponse clientResponse) throws Exception {
        URI target = this.uriMapper.mapFrom(clientRequest);
        if (target == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        final AsyncHandle asyncHandle = clientRequest.handleAsync();
        clientResponse.headers().remove(HeaderNames.DATE);
        long id = this.counter.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("[" + id + "] Proxying from " + clientRequest.uri() + " to " + target);
        }
        final AtomicReference<CompletableFuture<HttpResponse<Void>>> targetResponseFutureRef = new AtomicReference<CompletableFuture<HttpResponse<Void>>>();
        final AtomicReference<HttpRequest> targetRequestRef = new AtomicReference<HttpRequest>();
        final Consumer<Throwable> closeClientRequest = error -> {
            if (error != null) {
                log.warn("error detected for " + clientRequest, error);
            }
            if (error != null && !clientResponse.hasStartedSendingData()) {
                int status = error instanceof TimeoutException ? 504 : 500;
                String body = error instanceof TimeoutException ? "504 Gateway Timeout" : "500 Internal Server Error";
                clientResponse.status(status);
                asyncHandle.write(Mutils.toByteBuffer((String)body));
            }
            if (!clientResponse.responseState().endState()) {
                asyncHandle.complete();
            }
            CompletableFuture targetResponse = (CompletableFuture)targetResponseFutureRef.get();
            if (error != null && targetResponse != null && !targetResponse.isDone()) {
                log.info("cancelling target request for {}", (Object)clientRequest);
                targetResponse.cancel(true);
            }
        };
        boolean hasRequestBody = ReverseProxy.hasRequestBody(clientRequest);
        HttpRequest.BodyPublisher bodyPublisher = hasRequestBody ? new HttpRequest.BodyPublisher(){

            @Override
            public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
                try {
                    final ConcurrentLinkedDeque doneCallbacks = new ConcurrentLinkedDeque();
                    final AtomicBoolean isFirst = new AtomicBoolean(true);
                    subscriber.onSubscribe(new Flow.Subscription(){

                        @Override
                        public void request(long n) {
                            DoneCallback doneCallback = (DoneCallback)doneCallbacks.poll();
                            if (doneCallback != null) {
                                try {
                                    doneCallback.onComplete(null);
                                }
                                catch (Exception e) {
                                    log.warn("onComplete failed", (Throwable)e);
                                    this.cancel();
                                }
                            }
                            if (isFirst.compareAndSet(true, false)) {
                                asyncHandle.setReadListener(new RequestBodyListener(){

                                    public void onDataReceived(ByteBuffer byteBuffer, DoneCallback doneCallback) throws Exception {
                                        doneCallbacks.add(doneCallback);
                                        subscriber.onNext(byteBuffer);
                                    }

                                    public void onComplete() {
                                        subscriber.onComplete();
                                    }

                                    public void onError(Throwable throwable) {
                                        subscriber.onError(throwable);
                                        closeClientRequest.accept(new RuntimeException("request body read error"));
                                    }
                                });
                            }
                        }

                        @Override
                        public void cancel() {
                            closeClientRequest.accept(new RuntimeException("request body send cancel"));
                        }
                    });
                }
                catch (Throwable throwable) {
                    log.info("body subscribe error", throwable);
                    throw throwable;
                }
            }

            @Override
            public long contentLength() {
                String contentLength = clientRequest.headers().get(HeaderNames.CONTENT_LENGTH);
                if (contentLength != null) {
                    return Long.parseLong(contentLength);
                }
                return -1L;
            }
        } : HttpRequest.BodyPublishers.noBody();
        HttpRequest.Builder targetReq = HttpRequest.newBuilder().uri(target).method(clientRequest.method().toString(), bodyPublisher);
        final String viaValue = clientRequest.protocol() + " " + this.viaName;
        ReverseProxy.setTargetRequestHeaders(clientRequest, targetReq, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, viaValue, this.doNotProxyToTarget);
        HttpResponse.BodyHandler<Void> bh = new HttpResponse.BodyHandler<Void>(){

            @Override
            public HttpResponse.BodySubscriber<Void> apply(HttpResponse.ResponseInfo responseInfo) {
                clientResponse.status(responseInfo.statusCode());
                for (Map.Entry<String, List<String>> headerEntry : responseInfo.headers().map().entrySet()) {
                    for (String value : headerEntry.getValue()) {
                        String header = headerEntry.getKey();
                        String lowerName = header.toLowerCase();
                        if (HOP_BY_HOP_HEADERS.contains(lowerName)) continue;
                        clientResponse.headers().add(header, (Object)value);
                    }
                }
                String newVia = ReverseProxy.getNewViaValue(viaValue, clientResponse.headers().getAll(HeaderNames.VIA));
                clientResponse.headers().set(HeaderNames.VIA, (Object)newVia);
                if (ReverseProxy.this.responseInterceptor != null) {
                    try {
                        ReverseProxy.this.responseInterceptor.intercept(clientRequest, (HttpRequest)targetRequestRef.get(), responseInfo, clientResponse);
                    }
                    catch (Exception e) {
                        log.info("responseInterceptor error", (Throwable)e);
                    }
                }
                return HttpResponse.BodySubscribers.fromSubscriber((Flow.Subscriber<? super List<ByteBuffer>>)new Flow.Subscriber<List<ByteBuffer>>(){
                    private Flow.Subscription subscription;

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        this.subscription = subscription;
                        subscription.request(1L);
                    }

                    @Override
                    public void onNext(List<ByteBuffer> item) {
                        for (ByteBuffer byteBuffer : item) {
                            if (clientResponse.responseState().endState()) {
                                this.subscription.cancel();
                                return;
                            }
                            asyncHandle.write(byteBuffer, throwable -> {
                                if (throwable != null) {
                                    this.onError(throwable);
                                    return;
                                }
                                this.subscription.request(1L);
                            });
                        }
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        closeClientRequest.accept(throwable);
                    }

                    @Override
                    public void onComplete() {
                        targetResponseFutureRef.set(null);
                        asyncHandle.complete();
                    }
                });
            }
        };
        if (this.requestInterceptor != null) {
            try {
                this.requestInterceptor.intercept(clientRequest, targetReq);
            }
            catch (Throwable throwable2) {
                log.info("requestInterceptor error", throwable2);
                clientResponse.status(500);
                asyncHandle.complete();
                return true;
            }
        }
        HttpRequest targetRequest = targetReq.build();
        targetRequestRef.set(targetRequest);
        targetResponseFutureRef.set(this.httpClient.sendAsync(targetRequest, bh));
        ((CompletableFuture)targetResponseFutureRef.get()).orTimeout(this.totalTimeoutInMillis, TimeUnit.MILLISECONDS).whenComplete((voidHttpResponse, throwable) -> {
            long duration = System.currentTimeMillis() - start;
            closeClientRequest.accept((Throwable)throwable);
            for (ProxyCompleteListener proxyCompleteListener : this.proxyCompleteListeners) {
                try {
                    proxyCompleteListener.onComplete(clientRequest, clientResponse, target, duration);
                }
                catch (Exception e) {
                    log.warn("proxyCompleteListener error", (Throwable)e);
                }
            }
        });
        return true;
    }

    private static boolean hasRequestBody(MuRequest request) {
        for (Map.Entry header : request.headers()) {
            String headerName = ((String)header.getKey()).toLowerCase();
            if (!headerName.equals("content-length") && !headerName.equals("transfer-encoding")) continue;
            return true;
        }
        return false;
    }

    private static boolean setTargetRequestHeaders(MuRequest clientRequest, HttpRequest.Builder targetRequest, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue, Set<String> excludedHeaders) {
        Headers reqHeaders = clientRequest.headers();
        List<String> customHopByHop = ReverseProxy.getCustomHopByHopHeaders(reqHeaders.get(HeaderNames.CONNECTION));
        boolean hasContentLengthOrTransferEncoding = false;
        for (Map.Entry clientHeader : reqHeaders) {
            String key = (String)clientHeader.getKey();
            String lowKey = key.toLowerCase();
            hasContentLengthOrTransferEncoding |= lowKey.equals("content-length") || lowKey.equals("transfer-encoding");
            if (excludedHeaders.contains(lowKey) || customHopByHop.contains(lowKey) || HttpClientUtils.DISALLOWED_REQUEST_HEADERS.contains(lowKey)) continue;
            targetRequest.header(key, (String)clientHeader.getValue());
        }
        String newViaValue = ReverseProxy.getNewViaValue(viaValue, clientRequest.headers().getAll(HeaderNames.VIA));
        targetRequest.header(HeaderNames.VIA.toString(), newViaValue);
        ReverseProxy.setForwardedHeaders(clientRequest, targetRequest, discardClientForwardedHeaders, sendLegacyForwardedHeaders);
        return hasContentLengthOrTransferEncoding;
    }

    private static String getNewViaValue(String viaValue, List<String> previousViasList) {
        Object previousVias = String.join((CharSequence)", ", previousViasList);
        if (!((String)previousVias).isEmpty()) {
            previousVias = (String)previousVias + ", ";
        }
        return (String)previousVias + viaValue;
    }

    public static void setForwardedHeaders(MuRequest clientRequest, HttpRequest.Builder targetRequestBuilder, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders) {
        List forwardHeaders;
        Mutils.notNull((String)"clientRequest", (Object)clientRequest);
        Mutils.notNull((String)"targetRequest", (Object)targetRequestBuilder);
        if (discardClientForwardedHeaders) {
            forwardHeaders = Collections.emptyList();
        } else {
            forwardHeaders = clientRequest.headers().forwarded();
            for (ForwardedHeader existing : forwardHeaders) {
                targetRequestBuilder.header(HeaderNames.FORWARDED.toString(), existing.toString());
            }
        }
        ForwardedHeader newForwarded = ReverseProxy.createForwardedHeader(clientRequest);
        targetRequestBuilder.header(HeaderNames.FORWARDED.toString(), newForwarded.toString());
        if (sendLegacyForwardedHeaders) {
            ForwardedHeader first = forwardHeaders.isEmpty() ? newForwarded : (ForwardedHeader)forwardHeaders.get(0);
            ReverseProxy.setXForwardedHeaders(targetRequestBuilder, first);
        }
    }

    private static void setXForwardedHeaders(HttpRequest.Builder targetRequest, ForwardedHeader forwardedHeader) {
        targetRequest.header(HeaderNames.X_FORWARDED_PROTO.toString(), forwardedHeader.proto());
        targetRequest.header(HeaderNames.X_FORWARDED_HOST.toString(), forwardedHeader.host());
        targetRequest.header(HeaderNames.X_FORWARDED_FOR.toString(), forwardedHeader.forValue());
    }

    private static ForwardedHeader createForwardedHeader(MuRequest clientRequest) {
        String forwardedFor = clientRequest.remoteAddress();
        String proto = clientRequest.serverURI().getScheme();
        String host = clientRequest.headers().get(HeaderNames.HOST);
        return new ForwardedHeader(ipAddress, forwardedFor, host, proto, null);
    }

    private static List<String> getCustomHopByHopHeaders(String connectionHeaderValue) {
        String[] split;
        if (connectionHeaderValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> customHopByHop = new ArrayList<String>();
        for (String s : split = connectionHeaderValue.split("\\s*,\\s*")) {
            customHopByHop.add(s.toLowerCase());
        }
        return customHopByHop;
    }

    static {
        String ip;
        log = LoggerFactory.getLogger(ReverseProxy.class);
        HOP_BY_HOP_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("keep-alive", "transfer-encoding", "te", "connection", "trailer", "upgrade", "proxy-authorization", "proxy-authenticate")));
        REPRESSED = new HashSet<String>(HOP_BY_HOP_HEADERS);
        REPRESSED.addAll(new HashSet<String>(Arrays.asList("forwarded", "x-forwarded-by", "x-forwarded-for", "x-forwarded-host", "x-forwarded-proto", "x-forwarded-port", "x-forwarded-server", "via", "expect")));
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            ip = "unknown";
            log.info("Could not fine local address so using " + ip);
        }
        ipAddress = ip;
    }
}

