/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpClientUtils {
    static final List<String> DISALLOWED_REQUEST_HEADERS;

    HttpClientUtils() {
    }

    static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8).replace("+", "%20");
    }

    static HttpClient.Builder createHttpClientBuilder(boolean trustAll) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (trustAll) {
            HttpClientUtils.trustAll(builder);
        }
        return builder;
    }

    private static void setPropertyIfUnset(String key, String value) {
        String custom = System.getProperty(key, null);
        if (custom == null) {
            System.setProperty(key, value);
        }
    }

    private static void trustAll(HttpClient.Builder builder) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            builder.sslContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HttpClientUtils.setPropertyIfUnset("jdk.httpclient.allowRestrictedHeaders", "host,date,via,warning,from,origin,referer,connection");
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        Set<String> headersThatJDKMayReject = Set.of("date", "expect", "from", "host", "origin", "referer", "via", "warning");
        ArrayList<String> disallowed = new ArrayList<String>();
        for (String header : headersThatJDKMayReject) {
            try {
                builder.header(header, "dummy");
            }
            catch (IllegalArgumentException e) {
                disallowed.add(header);
            }
        }
        disallowed.add("content-length");
        DISALLOWED_REQUEST_HEADERS = Collections.unmodifiableList(disallowed);
    }
}

