/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import io.muserver.AsyncHandle;
import io.muserver.ContentTypes;
import io.muserver.DoneCallback;
import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.RequestBodyListener;
import io.muserver.murp.ProxyCompleteListener;
import io.muserver.murp.RequestInterceptor;
import io.muserver.murp.ResponseInterceptor;
import io.muserver.murp.UriMapper;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxy
implements MuHandler {
    private static final Logger log;
    public static final Set<String> HOP_BY_HOP_HEADERS;
    private static final Set<String> REPRESSED;
    private final AtomicLong counter = new AtomicLong();
    private final HttpClient httpClient;
    private final UriMapper uriMapper;
    private final long totalTimeoutInMillis;
    private final List<ProxyCompleteListener> proxyCompleteListeners;
    private final Set<String> doNotProxyToTarget = new HashSet<String>();
    private static final String ipAddress;
    private final String viaName;
    private final boolean discardClientForwardedHeaders;
    private final boolean sendLegacyForwardedHeaders;
    private final RequestInterceptor requestInterceptor;
    private final ResponseInterceptor responseInterceptor;

    ReverseProxy(HttpClient httpClient, UriMapper uriMapper, long totalTimeoutInMillis, List<ProxyCompleteListener> proxyCompleteListeners, String viaName, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, Set<String> additionalDoNotProxyHeaders, RequestInterceptor requestInterceptor, ResponseInterceptor responseInterceptor) {
        this.httpClient = httpClient;
        this.uriMapper = uriMapper;
        this.totalTimeoutInMillis = totalTimeoutInMillis;
        this.proxyCompleteListeners = proxyCompleteListeners;
        this.viaName = viaName;
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.doNotProxyToTarget.addAll(REPRESSED);
        additionalDoNotProxyHeaders.forEach(h -> this.doNotProxyToTarget.add(h.toLowerCase()));
    }

    public boolean handle(MuRequest clientReq, MuResponse clientResp) throws Exception {
        URI target = this.uriMapper.mapFrom(clientReq);
        if (target == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        clientResp.headers().remove(HeaderNames.DATE);
        AsyncHandle asyncHandle = clientReq.handleAsync();
        long id = this.counter.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("[" + id + "] Proxying from " + clientReq.uri() + " to " + target);
        }
        Request targetReq = this.httpClient.newRequest(target);
        targetReq.method(clientReq.method().name());
        String viaValue = clientReq.protocol() + " " + this.viaName;
        boolean hasRequestBody = ReverseProxy.setTargetRequestHeaders(clientReq, targetReq, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, viaValue, this.doNotProxyToTarget);
        if (hasRequestBody) {
            final DeferredContentProvider targetReqBody = new DeferredContentProvider(new ByteBuffer[0]);
            asyncHandle.setReadListener(new RequestBodyListener(){

                public void onDataReceived(ByteBuffer buffer, final DoneCallback done) {
                    targetReqBody.offer(buffer, new Callback(){

                        public void succeeded() {
                            try {
                                done.onComplete(null);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("onComplete(null) failed", e);
                            }
                        }

                        public void failed(Throwable x) {
                            try {
                                done.onComplete(x);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("onComplete(Throwable) failed", e);
                            }
                        }
                    });
                }

                public void onComplete() {
                    targetReqBody.close();
                }

                public void onError(Throwable t) {
                    targetReqBody.failed(t);
                }
            });
            targetReq.content((ContentProvider)targetReqBody);
        }
        targetReq.onResponseHeaders(response -> {
            clientResp.status(response.getStatus());
            HttpFields targetRespHeaders = response.getHeaders();
            List<String> customHopByHopHeaders = ReverseProxy.getCustomHopByHopHeaders(targetRespHeaders.get(HttpHeader.CONNECTION));
            for (HttpField targetRespHeader : targetRespHeaders) {
                String lowerName = targetRespHeader.getName().toLowerCase();
                if (HOP_BY_HOP_HEADERS.contains(lowerName) || customHopByHopHeaders.contains(lowerName)) continue;
                String value = targetRespHeader.getValue();
                clientResp.headers().add(targetRespHeader.getName(), (Object)value);
            }
            String newVia = ReverseProxy.getNewViaValue(viaValue, targetRespHeaders.getValuesList(HttpHeader.VIA));
            clientResp.headers().set(HeaderNames.VIA, (Object)newVia);
            if (this.responseInterceptor != null) {
                try {
                    this.responseInterceptor.intercept(clientReq, targetReq, response, clientResp);
                }
                catch (Exception e) {
                    log.error("Error while intercepting the response. The response will still be proxied.", (Throwable)e);
                }
            }
        });
        targetReq.onResponseContentAsync((response, content, callback) -> asyncHandle.write(content, error -> {
            if (error == null) {
                callback.succeeded();
            } else {
                callback.failed(error);
            }
        }));
        targetReq.timeout(this.totalTimeoutInMillis, TimeUnit.MILLISECONDS);
        if (this.requestInterceptor != null) {
            this.requestInterceptor.intercept(clientReq, targetReq);
        }
        targetReq.send(result -> {
            long duration = System.currentTimeMillis() - start;
            try {
                if (result.isFailed()) {
                    String errorID = UUID.randomUUID().toString();
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to proxy response. ErrorID=" + errorID + " for " + result, result.getFailure());
                    }
                    if (!clientResp.hasStartedSendingData()) {
                        clientResp.contentType(ContentTypes.TEXT_HTML);
                        if (result.getFailure() instanceof TimeoutException) {
                            clientResp.status(504);
                            clientResp.write("<h1>504 Gateway Timeout</h1><p>The target did not respond in a timely manner. ErrorID=" + errorID + "</p>");
                        } else {
                            clientResp.status(502);
                            clientResp.write("<h1>502 Bad Gateway</h1><p>ErrorID=" + errorID + "</p>");
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.info("[" + id + "] completed in " + duration + "ms: " + result);
                }
            }
            finally {
                asyncHandle.complete();
                for (ProxyCompleteListener proxyCompleteListener : this.proxyCompleteListeners) {
                    try {
                        proxyCompleteListener.onComplete(clientReq, clientResp, target, duration);
                    }
                    catch (Exception e) {
                        log.warn(proxyCompleteListener + " threw an error while processing onComplete", (Throwable)e);
                    }
                }
            }
        });
        return true;
    }

    public static boolean setRequestHeaders(MuRequest clientRequest, Request targetRequest, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue) {
        Mutils.notNull((String)"clientRequest", (Object)clientRequest);
        Mutils.notNull((String)"targetRequest", (Object)targetRequest);
        return ReverseProxy.setTargetRequestHeaders(clientRequest, targetRequest, discardClientForwardedHeaders, sendLegacyForwardedHeaders, viaValue, REPRESSED);
    }

    private static boolean setTargetRequestHeaders(MuRequest clientRequest, Request targetRequest, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue, Set<String> excludedHeaders) {
        Headers reqHeaders = clientRequest.headers();
        List<String> customHopByHop = ReverseProxy.getCustomHopByHopHeaders(reqHeaders.get(HeaderNames.CONNECTION));
        boolean hasContentLengthOrTransferEncoding = false;
        for (Map.Entry clientHeader : reqHeaders) {
            String key = (String)clientHeader.getKey();
            String lowKey = key.toLowerCase();
            if (excludedHeaders.contains(lowKey) || customHopByHop.contains(lowKey)) continue;
            hasContentLengthOrTransferEncoding |= lowKey.equals("content-length") || lowKey.equals("transfer-encoding");
            targetRequest.header(key, (String)clientHeader.getValue());
        }
        String newViaValue = ReverseProxy.getNewViaValue(viaValue, clientRequest.headers().getAll(HeaderNames.VIA));
        targetRequest.header(HttpHeader.VIA, newViaValue);
        ReverseProxy.setForwardedHeaders(clientRequest, targetRequest, discardClientForwardedHeaders, sendLegacyForwardedHeaders);
        return hasContentLengthOrTransferEncoding;
    }

    private static String getNewViaValue(String viaValue, List<String> previousViasList) {
        String previousVias = String.join((CharSequence)", ", previousViasList);
        if (!previousVias.isEmpty()) {
            previousVias = previousVias + ", ";
        }
        return previousVias + viaValue;
    }

    public static void setForwardedHeaders(MuRequest clientRequest, Request targetRequest, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders) {
        List forwardHeaders;
        Mutils.notNull((String)"clientRequest", (Object)clientRequest);
        Mutils.notNull((String)"targetRequest", (Object)targetRequest);
        if (discardClientForwardedHeaders) {
            forwardHeaders = Collections.emptyList();
        } else {
            forwardHeaders = clientRequest.headers().forwarded();
            for (ForwardedHeader existing : forwardHeaders) {
                targetRequest.header(HttpHeader.FORWARDED, existing.toString());
            }
        }
        ForwardedHeader newForwarded = ReverseProxy.createForwardedHeader(clientRequest);
        targetRequest.header(HttpHeader.FORWARDED, newForwarded.toString());
        if (sendLegacyForwardedHeaders) {
            ForwardedHeader first = forwardHeaders.isEmpty() ? newForwarded : (ForwardedHeader)forwardHeaders.get(0);
            ReverseProxy.setXForwardedHeaders(targetRequest, first);
        }
    }

    private static void setXForwardedHeaders(Request targetRequest, ForwardedHeader forwardedHeader) {
        targetRequest.header(HttpHeader.X_FORWARDED_PROTO, forwardedHeader.proto());
        targetRequest.header(HttpHeader.X_FORWARDED_HOST, forwardedHeader.host());
        targetRequest.header(HttpHeader.X_FORWARDED_FOR, forwardedHeader.forValue());
    }

    private static ForwardedHeader createForwardedHeader(MuRequest clientRequest) {
        String forwardedFor = clientRequest.remoteAddress();
        String proto = clientRequest.serverURI().getScheme();
        String host = clientRequest.headers().get(HeaderNames.HOST);
        return new ForwardedHeader(ipAddress, forwardedFor, host, proto, null);
    }

    private static List<String> getCustomHopByHopHeaders(String connectionHeaderValue) {
        String[] split;
        if (connectionHeaderValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> customHopByHop = new ArrayList<String>();
        for (String s : split = connectionHeaderValue.split("\\s*,\\s*")) {
            customHopByHop.add(s.toLowerCase());
        }
        return customHopByHop;
    }

    static {
        String ip;
        log = LoggerFactory.getLogger(ReverseProxy.class);
        HOP_BY_HOP_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("keep-alive", "transfer-encoding", "te", "connection", "trailer", "upgrade", "proxy-authorization", "proxy-authenticate")));
        REPRESSED = new HashSet<String>(HOP_BY_HOP_HEADERS);
        REPRESSED.addAll(new HashSet<String>(Arrays.asList("forwarded", "x-forwarded-by", "x-forwarded-for", "x-forwarded-host", "x-forwarded-proto", "x-forwarded-port", "x-forwarded-server", "via", "expect")));
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            ip = "unknown";
            log.info("Could not fine local address so using " + ip);
        }
        ipAddress = ip;
    }
}

