/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import java.net.CookieStore;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpClientBuilder {
    private long idleTimeoutMillis = 60000L;
    private long connectTimeoutMillis = 15000L;
    private long addressResolutionTimeoutMillis = 15000L;
    private int maxConnectionsPerDestination = 256;
    private SslContextFactory sslContextFactory;

    public HttpClientBuilder withIdleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public HttpClientBuilder withConnectTimeoutMillis(long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public HttpClientBuilder withAddressResolutionTimeoutMillis(long addressResolutionTimeoutMillis) {
        this.addressResolutionTimeoutMillis = addressResolutionTimeoutMillis;
        return this;
    }

    public HttpClientBuilder withMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
        return this;
    }

    public HttpClientBuilder withSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        return this;
    }

    public static HttpClientBuilder httpClient() {
        return new HttpClientBuilder();
    }

    public HttpClient build() {
        int selectors = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        SslContextFactory scf = this.sslContextFactory != null ? this.sslContextFactory : new SslContextFactory(true);
        HttpClient client = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(selectors), scf);
        client.setFollowRedirects(false);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setMaxConnectionsPerDestination(this.maxConnectionsPerDestination);
        client.setAddressResolutionTimeout(this.addressResolutionTimeoutMillis);
        client.setConnectTimeout(this.connectTimeoutMillis);
        client.setIdleTimeout(this.idleTimeoutMillis);
        client.setUserAgentField(null);
        try {
            client.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while starting HTTP Client for reverse proxy", e);
        }
        client.getContentDecoderFactories().clear();
        return client;
    }
}

