/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.murp;

import io.muserver.MuHandlerBuilder;
import io.muserver.Mutils;
import io.muserver.murp.HttpClientBuilder;
import io.muserver.murp.ProxyCompleteListener;
import io.muserver.murp.ReverseProxy;
import io.muserver.murp.UriMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;

public class ReverseProxyBuilder
implements MuHandlerBuilder<ReverseProxy> {
    private String viaName = "private";
    private HttpClient httpClient;
    private UriMapper uriMapper;
    private boolean sendLegacyForwardedHeaders;
    private boolean discardClientForwardedHeaders;
    private long totalTimeoutInMillis = TimeUnit.MINUTES.toMillis(5L);
    private List<ProxyCompleteListener> proxyCompleteListeners;
    private Set<String> doNotProxyHeaders = new HashSet<String>();

    public ReverseProxyBuilder withViaName(String viaName) {
        Mutils.notNull((String)"viaName", (Object)viaName);
        this.viaName = viaName;
        return this;
    }

    public ReverseProxyBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ReverseProxyBuilder withUriMapper(UriMapper uriMapper) {
        this.uriMapper = uriMapper;
        return this;
    }

    public ReverseProxyBuilder sendLegacyForwardedHeaders(boolean sendLegacyForwardedHeaders) {
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        return this;
    }

    public ReverseProxyBuilder proxyHostHeader(boolean sendHostToTarget) {
        if (sendHostToTarget) {
            this.doNotProxyHeaders.remove("host");
        } else {
            this.doNotProxyHeaders.add("host");
        }
        return this;
    }

    public ReverseProxyBuilder discardClientForwardedHeaders(boolean discardClientForwardedHeaders) {
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        return this;
    }

    public ReverseProxyBuilder withTotalTimeout(long totalTimeoutInMillis) {
        this.totalTimeoutInMillis = totalTimeoutInMillis;
        return this;
    }

    public ReverseProxyBuilder withTotalTimeout(long totalTimeout, TimeUnit unit) {
        return this.withTotalTimeout(unit.toMillis(totalTimeout));
    }

    public ReverseProxyBuilder addProxyCompleteListener(ProxyCompleteListener proxyCompleteListener) {
        if (this.proxyCompleteListeners == null) {
            this.proxyCompleteListeners = new ArrayList<ProxyCompleteListener>(1);
        }
        this.proxyCompleteListeners.add(proxyCompleteListener);
        return this;
    }

    public static ReverseProxyBuilder reverseProxy() {
        return new ReverseProxyBuilder();
    }

    public ReverseProxy build() {
        List<ProxyCompleteListener> proxyCompleteListeners;
        if (this.uriMapper == null) {
            throw new IllegalStateException("A URI mapper must be specified");
        }
        HttpClient client = this.httpClient;
        if (client == null) {
            client = HttpClientBuilder.httpClient().build();
        }
        if ((proxyCompleteListeners = this.proxyCompleteListeners) == null) {
            proxyCompleteListeners = Collections.emptyList();
        }
        return new ReverseProxy(client, this.uriMapper, this.totalTimeoutInMillis, proxyCompleteListeners, this.viaName, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.doNotProxyHeaders);
    }
}

