/**
 * Copyright (C) 2013 Motown.IO (info@motown.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.motown.identificationauthorization.pluginapi;

import io.motown.domain.api.chargingstation.IdentifyingToken;

/**
 * Should be implemented by every AuthorizationProvider used in the Identification Authorization add-on.
 */
public interface AuthorizationProvider {

    /**
     * Validates the identification.
     *
     * @param identification the identification to validate.
     * @return true if the identification is valid, false if not or if the identification is unknown.
     */
    boolean isValid(IdentifyingToken identification);

}
