/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.RangeUtils;
import io.milton.common.StreamUtils;
import io.milton.http.Range;
import io.milton.zsync.ByteRange;
import io.milton.zsync.RelocateRange;
import io.milton.zsync.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadReader {
    private static final Logger log = LoggerFactory.getLogger(UploadReader.class);
    private final File serverCopy;
    private final File uploadedCopy;
    private final Upload uploadData;

    public static void moveBlocks(byte[] in, List<RelocateRange> rlist, int blockSize, byte[] out) {
        for (RelocateRange reloc : rlist) {
            int startBlock = (int)reloc.getBlockRange().getStart().longValue();
            int finishBlock = (int)reloc.getBlockRange().getFinish().longValue();
            int startByte = startBlock * blockSize;
            int newOffset = (int)reloc.getOffset();
            int numBytes = (finishBlock - startBlock) * blockSize;
            System.arraycopy(in, startByte, out, newOffset, numBytes);
        }
    }

    public static void moveBlocks(File inFile, Enumeration<RelocateRange> relocRanges, int blocksize, File outFile) throws IOException {
        try (FileChannel rc = new RandomAccessFile(inFile, "r").getChannel();
             FileChannel wc = new RandomAccessFile(outFile, "rw").getChannel();){
            while (relocRanges.hasMoreElements()) {
                UploadReader.moveRange(rc, relocRanges.nextElement(), blocksize, wc);
            }
        }
    }

    private static void moveRange(FileChannel rc, RelocateRange reloc, int blockSize, FileChannel wc) throws IOException {
        long MAX_BUFFER = 16384L;
        long startBlock = reloc.getBlockRange().getStart();
        long finishBlock = reloc.getBlockRange().getFinish();
        long bytesLeft = (finishBlock - startBlock) * (long)blockSize;
        long readAtOnce = 0L;
        long bytesRead = 0L;
        long currOffset = reloc.getOffset();
        if (finishBlock * (long)blockSize > rc.size() || startBlock < 0L) {
            throw new RuntimeException("Invalid RelocateRange: Source file does not contain blocks " + reloc.getBlockRange().getRange());
        }
        rc.position(startBlock * (long)blockSize);
        while (bytesLeft > 0L) {
            readAtOnce = Math.min(bytesLeft, MAX_BUFFER);
            bytesRead = wc.transferFrom(rc, currOffset, readAtOnce);
            bytesLeft -= bytesRead;
            currOffset += bytesRead;
        }
    }

    public static void sendRanges(byte[] in, List<Range> ranges, byte[] out) {
        int pos = 0;
        for (Range r : ranges) {
            int length = (int)(r.getFinish() - r.getStart());
            System.arraycopy(in, pos, out, r.getStart().intValue(), length);
            pos += length;
        }
    }

    public static void sendRanges(Enumeration<ByteRange> byteRanges, File outFile) throws IOException {
        int BUFFER_SIZE = 16384;
        byte[] buffer = new byte[BUFFER_SIZE];
        try (RandomAccessFile randAccess = new RandomAccessFile(outFile, "rw");){
            while (byteRanges.hasMoreElements()) {
                ByteRange byteRange = byteRanges.nextElement();
                Range range = byteRange.getRange();
                InputStream data = byteRange.getDataQueue();
                UploadReader.sendBytes(data, range, buffer, randAccess);
            }
        }
    }

    private static void sendBytes(InputStream dataIn, Range range, byte[] buffer, RandomAccessFile fileOut) throws IOException {
        long bytesLeft = range.getFinish() - range.getStart();
        int bytesRead = 0;
        int readAtOnce = 0;
        fileOut.seek(range.getStart());
        while (bytesLeft > 0L) {
            readAtOnce = (int)Math.min((long)buffer.length, bytesLeft);
            bytesRead = dataIn.read(buffer, 0, readAtOnce);
            fileOut.write(buffer, 0, bytesRead);
            if ((bytesLeft -= (long)bytesRead) <= 0L || bytesRead >= 0) continue;
            throw new RuntimeException("Unable to copy byte Range: " + range.getRange() + ". End of InputStream reached with " + bytesLeft + " bytes left.");
        }
    }

    private static void copyFile(File inFile, File outFile, long length) throws IOException {
        try (FileInputStream fIn = new FileInputStream(inFile);
             FileOutputStream fOut = new FileOutputStream(outFile);){
            RangeUtils.sendBytes((InputStream)fIn, (OutputStream)fOut, (long)inFile.length());
        }
        try (RandomAccessFile randAccess = new RandomAccessFile(outFile, "rw");){
            randAccess.setLength(length);
        }
    }

    public UploadReader(File serverFile, InputStream uploadIn) throws IOException {
        this.serverCopy = serverFile;
        this.uploadData = Upload.parse(uploadIn);
        this.uploadedCopy = File.createTempFile("zsync-upload", "newFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File assemble() throws IOException {
        if (this.uploadData.getBlocksize() <= 0L) {
            throw new RuntimeException("Invalid blocksize specified: " + this.uploadData.getBlocksize());
        }
        if (this.uploadData.getFilelength() <= 0L) {
            throw new RuntimeException("Invalid file length specified: " + this.uploadData.getFilelength());
        }
        if (StringUtils.isBlank((String)this.uploadData.getSha1())) {
            throw new RuntimeException("No SHA1 checksum provided.");
        }
        InputStream relocIn = null;
        InputStream dataIn = null;
        try {
            relocIn = this.uploadData.getRelocStream();
            dataIn = this.uploadData.getDataStream();
            RelocateParser relocEnum = new RelocateParser(relocIn);
            ByteRangeParser dataEnum = new ByteRangeParser(dataIn);
            UploadReader.copyFile(this.serverCopy, this.uploadedCopy, this.uploadData.getFilelength());
            UploadReader.moveBlocks(this.serverCopy, relocEnum, (int)this.uploadData.getBlocksize(), this.uploadedCopy);
            UploadReader.sendRanges(dataEnum, this.uploadedCopy);
        }
        catch (Throwable throwable) {
            StreamUtils.close((InputStream)relocIn);
            StreamUtils.close(dataIn);
            throw throwable;
        }
        StreamUtils.close((InputStream)relocIn);
        StreamUtils.close((InputStream)dataIn);
        return this.uploadedCopy;
    }

    public String getChecksum() {
        return this.uploadData.getSha1();
    }

    private static class RelocateParser
    implements Enumeration<RelocateRange> {
        private InputStream relocIn;
        private String nextToken;
        private final byte[] COMMA = new byte[1];

        public RelocateParser(InputStream relocIn) {
            try {
                this.relocIn = relocIn;
                this.COMMA[0] = ",".getBytes("US-ASCII")[0];
                this.nextToken = Upload.readToken(relocIn, this.COMMA, 64);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return !StringUtils.isBlank((String)this.nextToken);
        }

        @Override
        public RelocateRange nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more RelocateRanges");
            }
            try {
                RelocateRange reloc = RelocateRange.parse(this.nextToken);
                this.nextToken = Upload.readToken(this.relocIn, this.COMMA, 64);
                return reloc;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class ByteRangeParser
    implements Enumeration<ByteRange> {
        private final InputStream dataQueue;
        private Range nextRange;
        private boolean rangeloaded;
        private final byte[] COLON = new byte[]{":".getBytes("US-ASCII")[0]};

        public ByteRangeParser(InputStream in) throws UnsupportedEncodingException {
            this.dataQueue = in;
            this.rangeloaded = false;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                if (this.rangeloaded) {
                    return this.nextRange != null;
                }
                String nextKey = Upload.readToken(this.dataQueue, this.COLON, 64).trim();
                if (StringUtils.isBlank((String)nextKey)) {
                    this.nextRange = null;
                } else {
                    if (!nextKey.equalsIgnoreCase("Range")) {
                        throw new RuntimeException("Invalid key. Expected: Range\tActual: " + nextKey);
                    }
                    this.nextRange = Range.parse((String)Upload.readValue(this.dataQueue, 64).trim());
                }
                this.rangeloaded = true;
                return this.nextRange != null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public ByteRange nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more ByteRanges");
            }
            this.rangeloaded = false;
            return new ByteRange(this.nextRange, this.dataQueue);
        }
    }
}

