/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.BufferingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Upload {
    public static final String CHARSET = "US-ASCII";
    public static final char LF = '\n';
    public String DIV = "--DIVIDER";
    public static final String VERSION = "zsync";
    public static final String BLOCKSIZE = "Blocksize";
    public static final String FILELENGTH = "Length";
    public static final String NEWDATA = "ContentLength";
    public static final String SHA_1 = "SHA-1";
    public static final String RELOCATE = "Relocate";
    public static final String RANGE = "Range";
    private String version;
    private String sha1;
    private long blocksize;
    private long filelength;
    private InputStream relocStream;
    private InputStream dataStream;

    public String getParams() {
        StringBuilder sbr = new StringBuilder();
        sbr.append(Upload.paramString(VERSION, this.version));
        sbr.append(Upload.paramString(FILELENGTH, this.filelength));
        sbr.append(Upload.paramString(BLOCKSIZE, this.blocksize));
        sbr.append(Upload.paramString(SHA_1, this.sha1));
        return sbr.toString();
    }

    public static String paramString(String key, Object value) {
        return key + ": " + value + '\n';
    }

    public static Upload parse(InputStream in) {
        Upload um = new Upload();
        int bytesRead = 0;
        try {
            String key;
            int MAX_SEARCH = 1024;
            while (!StringUtils.isBlank((String)(key = Upload.readKey(in, MAX_SEARCH)))) {
                bytesRead += key.length() + 1;
                if ((key = key.trim()).equalsIgnoreCase(RELOCATE)) {
                    BufferingOutputStream relocOut = new BufferingOutputStream(16384);
                    bytesRead += Upload.copyLine(in, 0x4000000, (OutputStream)relocOut);
                    relocOut.close();
                    um.setRelocStream(relocOut.getInputStream());
                    continue;
                }
                String value = Upload.readValue(in, MAX_SEARCH);
                bytesRead += value.length() + 1;
                value = value.trim();
                um.parseParam(key, value);
            }
            um.setDataStream(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parse upload, IOException.", e);
        }
        catch (ParseException e) {
            ParseException ex = new ParseException(e.getMessage(), bytesRead);
            throw new RuntimeException(ex);
        }
        return um;
    }

    public static String readToken(InputStream in, byte[] delimiters, int maxsearch) throws ParseException, IOException {
        if (maxsearch <= 0) {
            throw new RuntimeException("readToken: Invalid maxsearch " + maxsearch);
        }
        ByteBuffer bytes = ByteBuffer.allocate(maxsearch);
        try {
            byte nextByte;
            block2: while ((nextByte = (byte)in.read()) > -1) {
                for (byte delimiter : delimiters) {
                    if (nextByte == delimiter) break block2;
                }
                bytes.put(nextByte);
            }
            bytes.flip();
            return Charset.forName(CHARSET).decode(bytes).toString();
        }
        catch (BufferOverflowException ex) {
            throw new ParseException("Could not find delimiter within " + maxsearch + " bytes.", 0);
        }
    }

    private static String readKey(InputStream in, int maxsearch) throws ParseException, IOException {
        byte NEWLINE = Character.toString('\n').getBytes(CHARSET)[0];
        byte COLON = ":".getBytes(CHARSET)[0];
        byte[] delimiters = new byte[]{NEWLINE, COLON};
        return Upload.readToken(in, delimiters, maxsearch);
    }

    public static String readValue(InputStream in, int maxsearch) throws ParseException, IOException {
        byte NEWLINE = Character.toString('\n').getBytes(CHARSET)[0];
        byte[] delimiters = new byte[]{NEWLINE};
        return Upload.readToken(in, delimiters, maxsearch);
    }

    private static int copyLine(InputStream in, int maxsearch, OutputStream out) throws IOException, ParseException {
        byte nextByte;
        if (maxsearch <= 0) {
            throw new RuntimeException("copyLine: Invalid maxsearch " + maxsearch);
        }
        int bytesRead = 0;
        byte NEWLINE = Character.toString('\n').getBytes(CHARSET)[0];
        while ((nextByte = (byte)in.read()) > -1) {
            if ((bytesRead = (int)((byte)(bytesRead + 1))) > maxsearch) {
                throw new ParseException("Could not find delimiter within " + maxsearch + " bytes.", 0);
            }
            if (nextByte == NEWLINE) break;
            out.write(nextByte);
        }
        return bytesRead;
    }

    private void parseParam(String key, String value) throws ParseException {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
            return;
        }
        try {
            if (key.equalsIgnoreCase(VERSION)) {
                this.setVersion(value);
            } else if (key.equalsIgnoreCase(FILELENGTH)) {
                this.setFilelength(Long.parseLong(value));
            } else if (key.equalsIgnoreCase(BLOCKSIZE)) {
                this.setBlocksize(Long.parseLong(value));
            } else if (key.equalsIgnoreCase(SHA_1)) {
                this.setSha1(value);
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Cannot parse " + value + " into a long.", -1);
        }
    }

    public InputStream getInputStream() throws UnsupportedEncodingException, IOException {
        ArrayList<InputStream> streamList = new ArrayList<InputStream>();
        streamList.add(IOUtils.toInputStream((String)this.getParams(), (String)CHARSET));
        streamList.add(IOUtils.toInputStream((String)"Relocate: ", (String)CHARSET));
        streamList.add(this.getRelocStream());
        streamList.add(IOUtils.toInputStream((String)Character.toString('\n'), (String)CHARSET));
        streamList.add(this.getDataStream());
        return new SequenceInputStream(new IteratorEnum(streamList));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public void setBlocksize(long blocksize) {
        this.blocksize = blocksize;
    }

    public long getFilelength() {
        return this.filelength;
    }

    public void setFilelength(long filelength) {
        this.filelength = filelength;
    }

    public InputStream getRelocStream() {
        return this.relocStream;
    }

    public void setRelocStream(InputStream relocStream) {
        this.relocStream = relocStream;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(InputStream dataStream) {
        this.dataStream = dataStream;
    }

    public static class IteratorEnum<T>
    implements Enumeration<T> {
        final Iterator<T> iter;

        public IteratorEnum(List<T> list) {
            this.iter = list.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iter.next();
        }
    }

    public static class KeyValue {
        public final String KEY;
        public final String VALUE;

        public KeyValue(String key, String value) {
            this.KEY = key;
            this.VALUE = value;
        }

        public static KeyValue parseKV(String kv) throws ParseException {
            int colonIndex = kv.indexOf(58);
            if (colonIndex == -1) {
                throw new ParseException("No colon found in \"" + kv + "\"", colonIndex);
            }
            String key = kv.substring(0, colonIndex).trim();
            String value = kv.substring(colonIndex + 1).trim();
            return new KeyValue(key, value);
        }
    }
}

