/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient.zsyncclient;

import io.milton.http.Range;
import io.milton.httpclient.File;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.Utils;
import io.milton.httpclient.zsyncclient.RangeLoader;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRangeLoader
implements RangeLoader {
    private static final Logger log = LoggerFactory.getLogger(HttpRangeLoader.class);
    private final File file;
    private final ProgressListener listener;
    private long numBytes;

    public HttpRangeLoader(File file, ProgressListener listener) {
        this.file = file;
        this.listener = listener;
    }

    @Override
    public byte[] get(List<Range> rangeList) {
        log.info("get: rangelist: " + rangeList.size());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.file.download(out, this.listener, rangeList);
        }
        catch (HttpException httpException) {
        }
        catch (Utils.CancelledException ex) {
            throw new RuntimeException("Cancelled, which is odd because no progress listener was provided");
        }
        byte[] bytes = out.toByteArray();
        int expectedLength = HttpRangeLoader.calcExpectedLength(rangeList);
        this.numBytes += (long)bytes.length;
        return bytes;
    }

    public static int calcExpectedLength(List<Range> rangeList) {
        int l = 0;
        for (Range r : rangeList) {
            l = (int)((long)l + (r.getFinish() - r.getStart()));
        }
        return l;
    }

    public long getBytesDownloaded() {
        return this.numBytes;
    }
}

