/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient.calsync.parse;

import io.milton.httpclient.calsync.parse.annotation.Description;
import io.milton.httpclient.calsync.parse.annotation.EndDate;
import io.milton.httpclient.calsync.parse.annotation.Location;
import io.milton.httpclient.calsync.parse.annotation.Organizer;
import io.milton.httpclient.calsync.parse.annotation.StartDate;
import io.milton.httpclient.calsync.parse.annotation.Summary;
import io.milton.httpclient.calsync.parse.annotation.Timezone;
import io.milton.httpclient.calsync.parse.annotation.Uid;
import io.milton.httpclient.parse.PropertyAccessor;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.validate.ValidationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;

public class CalDavBeanPropertyMapper {
    private final Map<Class, Mapper> mapOfMappers;
    private final PropertyAccessor propertyAccessor;

    public CalDavBeanPropertyMapper(PropertyAccessor propertyAccessor) {
        this.propertyAccessor = propertyAccessor;
        this.mapOfMappers = new HashMap<Class, Mapper>();
        this.addMapper(Uid.class, new UidMapper());
        this.addMapper(Location.class, new LocationMapper());
        this.addMapper(Summary.class, new SummaryMapper());
        this.addMapper(Description.class, new DescriptionMapper());
        this.addMapper(EndDate.class, new EndDateMapper());
        this.addMapper(StartDate.class, new StartDateMapper());
        this.addMapper(Timezone.class, new TimezoneMapper());
        this.addMapper(Organizer.class, new OrganizerMapper());
    }

    private void addMapper(Class c, Mapper m) {
        this.mapOfMappers.put(c, m);
    }

    public void toBean(Object bean, String icalText) {
        ByteArrayInputStream fin = null;
        try {
            PropertyDescriptor[] pds;
            Calendar cal4jCalendar;
            fin = new ByteArrayInputStream(icalText.getBytes("UTF-8"));
            CalendarBuilder builder = new CalendarBuilder();
            try {
                cal4jCalendar = builder.build((InputStream)fin);
            }
            catch (IOException | ParserException ex) {
                throw new RuntimeException(icalText, ex);
            }
            for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
                Annotation[] annotations;
                if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
                Method read = pd.getReadMethod();
                for (Annotation anno : annotations = read.getAnnotations()) {
                    Mapper mapper = this.mapOfMappers.get(anno.annotationType());
                    if (mapper == null) continue;
                    mapper.mapToBean(cal4jCalendar, bean, pd);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    public <T> T getProperty(Object bean, Class annotationClass, Class<T> valueClass) {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Annotation[] annotations;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            Method read = pd.getReadMethod();
            for (Annotation anno : annotations = read.getAnnotations()) {
                if (anno.annotationType() != annotationClass) continue;
                return this.propertyAccessor.get(bean, read, valueClass);
            }
        }
        return null;
    }

    public String toVCard(Object bean) {
        PropertyDescriptor[] pds;
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Object)new ProdId("-//spliffy.org//iCal4j 1.0//EN"));
        calendar.getProperties().add((Object)Version.VERSION_2_0);
        VEvent vevent = new VEvent();
        calendar.getComponents().add((Object)vevent);
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Annotation[] annotations;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            Method read = pd.getReadMethod();
            for (Annotation anno : annotations = read.getAnnotations()) {
                Mapper mapper = this.mapOfMappers.get(anno.annotationType());
                if (mapper == null) continue;
                mapper.mapToCard(calendar, bean, pd);
            }
        }
        CalendarOutputter outputter = new CalendarOutputter();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            outputter.output(calendar, (OutputStream)bout);
        }
        catch (IOException | ValidationException ex) {
            throw new RuntimeException(ex);
        }
        return bout.toString();
    }

    private VEvent event(Calendar cal) {
        return (VEvent)cal.getComponent("VEVENT");
    }

    private VFreeBusy freeBusy(Calendar cal) {
        return (VFreeBusy)cal.getComponent("VFREEBUSY");
    }

    private String getPropValue(Property prop) {
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    private Date getDateValue(DateProperty prop) {
        if (prop == null) {
            return null;
        }
        return prop.getDate();
    }

    public class UidMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            net.fortuna.ical4j.model.property.Uid uidProp = null;
            if (vevent != null) {
                uidProp = vevent.getUid();
            } else {
                VFreeBusy fb = CalDavBeanPropertyMapper.this.freeBusy(cal);
                uidProp = fb.getUid();
            }
            Method m = pd.getWriteMethod();
            String uid = null;
            if (uidProp != null) {
                uid = uidProp.getValue();
            }
            if (uid == null) {
                uid = UUID.randomUUID().toString();
            }
            CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, m, uid);
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            String uid = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            vevent.getProperties().add((Object)new net.fortuna.ical4j.model.property.Uid(uid));
        }
    }

    public static abstract class Mapper {
        abstract void mapToBean(Calendar var1, Object var2, PropertyDescriptor var3);

        abstract void mapToCard(Calendar var1, Object var2, PropertyDescriptor var3);
    }

    public class LocationMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            if (vevent != null) {
                String s = CalDavBeanPropertyMapper.this.getPropValue((Property)vevent.getLocation());
                CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), s);
            }
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            String s = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            net.fortuna.ical4j.model.property.Location d = new net.fortuna.ical4j.model.property.Location(s);
            vevent.getProperties().add((Object)d);
        }
    }

    public class SummaryMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            if (vevent != null) {
                String s = CalDavBeanPropertyMapper.this.getPropValue((Property)vevent.getSummary());
                CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), s);
            }
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            String s = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            if (s == null || s.trim().length() == 0) {
                return;
            }
            net.fortuna.ical4j.model.property.Summary d = new net.fortuna.ical4j.model.property.Summary(s);
            vevent.getProperties().add((Object)d);
        }
    }

    public class DescriptionMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            if (vevent != null) {
                String desc = CalDavBeanPropertyMapper.this.getPropValue((Property)vevent.getDescription());
                CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), desc);
            } else {
                CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), null);
            }
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            String s = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            if (s == null || s.trim().length() == 0) {
                return;
            }
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            if (vevent != null) {
                net.fortuna.ical4j.model.property.Description d = new net.fortuna.ical4j.model.property.Description();
                d.setValue(s);
                vevent.getProperties().add((Object)d);
            }
        }
    }

    public class EndDateMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            Date dt = null;
            if (vevent != null) {
                dt = CalDavBeanPropertyMapper.this.getDateValue((DateProperty)vevent.getEndDate());
            } else {
                VFreeBusy fb = CalDavBeanPropertyMapper.this.freeBusy(cal);
                if (fb != null) {
                    dt = CalDavBeanPropertyMapper.this.getDateValue((DateProperty)fb.getEndDate());
                }
            }
            CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), dt);
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            java.util.Date d = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), java.util.Date.class);
            if (d == null) {
                return;
            }
            Date dt = new Date(d);
            DtEnd p = new DtEnd(dt);
            vevent.getProperties().add((Object)p);
        }
    }

    public class StartDateMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            Date dt = null;
            if (vevent != null) {
                dt = CalDavBeanPropertyMapper.this.getDateValue((DateProperty)vevent.getStartDate());
            } else {
                VFreeBusy fb = CalDavBeanPropertyMapper.this.freeBusy(cal);
                if (fb != null) {
                    dt = CalDavBeanPropertyMapper.this.getDateValue((DateProperty)fb.getStartDate());
                }
            }
            CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), dt);
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            java.util.Date d = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), java.util.Date.class);
            if (d == null) {
                return;
            }
            Date dt = new Date(d);
            DtStart p = new DtStart(dt);
            vevent.getProperties().add((Object)p);
        }
    }

    public class TimezoneMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            Method m = pd.getWriteMethod();
            String tzId = CalDavBeanPropertyMapper.this.getPropValue(cal.getProperty("TZID"));
            CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, m, tzId);
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
            String tzId = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            TimeZone timezone = null;
            if (tzId != null && tzId.length() > 0) {
                timezone = registry.getTimeZone(tzId);
            }
            if (timezone != null) {
                VTimeZone tz = timezone.getVTimeZone();
                cal.getComponents().add((Object)tz);
            }
        }
    }

    public class OrganizerMapper
    extends Mapper {
        @Override
        void mapToBean(Calendar cal, Object bean, PropertyDescriptor pd) {
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            if (vevent != null) {
                String s = CalDavBeanPropertyMapper.this.getPropValue((Property)vevent.getOrganizer());
                CalDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), s);
            }
        }

        @Override
        void mapToCard(Calendar cal, Object bean, PropertyDescriptor pd) {
            net.fortuna.ical4j.model.property.Organizer d;
            String s = CalDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            if (s == null || s.trim().length() == 0) {
                return;
            }
            VEvent vevent = CalDavBeanPropertyMapper.this.event(cal);
            try {
                d = new net.fortuna.ical4j.model.property.Organizer(s);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(s, ex);
            }
            vevent.getProperties().add((Object)d);
        }
    }
}

