/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespUtils {
    private static final Logger log = LoggerFactory.getLogger(RespUtils.class);
    public static final Namespace NS_DAV = Namespace.getNamespace((String)"D", (String)"DAV:");

    public static QName davName(String localName) {
        return new QName(NS_DAV.getURI(), localName, NS_DAV.getPrefix());
    }

    public static String asString(Element el, String name) {
        Element elChild = el.getChild(name, NS_DAV);
        if (elChild == null) {
            return null;
        }
        return elChild.getText();
    }

    public static String asString(Element el, String name, Namespace ns) {
        Element elChild = el.getChild(name, ns);
        if (elChild == null) {
            return null;
        }
        return elChild.getText();
    }

    public static Long asLong(Element el, String name) {
        String s = RespUtils.asString(el, name);
        if (s == null || s.length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    public static Long asLong(Element el, String name, Namespace ns) {
        String s = RespUtils.asString(el, name, ns);
        if (s == null || s.length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    public static boolean hasChild(Element el, String name) {
        if (el == null) {
            return false;
        }
        List<Element> list = RespUtils.getElements(el, name);
        return !list.isEmpty();
    }

    public static List<Element> getElements(Element root, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        IteratorIterable it = root.getDescendants((Filter)new ElementFilter(name));
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) continue;
            list.add((Element)o);
        }
        return list;
    }
}

