/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.DateUtils;
import io.milton.http.Range;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.ConnectionListener;
import io.milton.httpclient.CopyMethod;
import io.milton.httpclient.Folder;
import io.milton.httpclient.GenericHttpException;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.HttpResult;
import io.milton.httpclient.IfMatchCheck;
import io.milton.httpclient.LockMethod;
import io.milton.httpclient.MkColMethod;
import io.milton.httpclient.MoveMethod;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.PropFindMethod;
import io.milton.httpclient.PropFindResponse;
import io.milton.httpclient.ProxyDetails;
import io.milton.httpclient.Resource;
import io.milton.httpclient.RespUtils;
import io.milton.httpclient.StreamReceiver;
import io.milton.httpclient.TransferService;
import io.milton.httpclient.UnLockMethod;
import io.milton.httpclient.Utils;
import io.milton.httpclient.zsyncclient.FileSyncer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host
extends Folder {
    public static final List<QName> defaultFields = Arrays.asList(RespUtils.davName("resourcetype"), RespUtils.davName("etag"), RespUtils.davName("displayname"), RespUtils.davName("getcontentlength"), RespUtils.davName("creationdate"), RespUtils.davName("getlastmodified"), RespUtils.davName("iscollection"), RespUtils.davName("lockdiscovery"));
    private static final String LOCK_XML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D='DAV:'><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype><D:owner>${owner}</D:owner></D:lockinfo>";
    private static final Set<String> WEBDAV_REDIRECTABLE = new HashSet<String>(Arrays.asList("PROPFIND", "LOCK", "UNLOCK", "DELETE"));
    private static final Logger log = LoggerFactory.getLogger(Host.class);
    public final String server;
    public final Integer port;
    public final String user;
    public final String password;
    public final String rootPath;
    private int timeout;
    private final DefaultHttpClient client;
    private final TransferService transferService;
    private final FileSyncer fileSyncer;
    private final List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private boolean secure;
    private boolean usePreemptiveAuth = true;
    private boolean useDigestForPreemptiveAuth = true;
    private final Map<String, String> cookies = new HashMap<String, String>();

    public static Document getJDomDocument(InputStream in) throws JDOMException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)bout);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            return builder.build((InputStream)bin);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Host(String server, Integer port, String user, String password, ProxyDetails proxyDetails) {
        this(server, null, port, user, password, proxyDetails, 30000, null, null);
    }

    public Host(String server, Integer port, String user, String password, ProxyDetails proxyDetails, Map<Folder, List<Resource>> cache) {
        this(server, null, port, user, password, proxyDetails, 30000, cache, null);
    }

    public Host(String server, String rootPath, Integer port, String user, String password, ProxyDetails proxyDetails, Map<Folder, List<Resource>> cache) {
        this(server, rootPath, port, user, password, proxyDetails, 30000, cache, null);
    }

    public Host(String server, String rootPath, Integer port, String user, String password, ProxyDetails proxyDetails, int timeoutMillis, Map<Folder, List<Resource>> cache, FileSyncer fileSyncer) {
        super((Map<Folder, List<Resource>>)(cache != null ? cache : new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1000L).build()));
        if (server == null) {
            throw new IllegalArgumentException("host name cannot be null");
        }
        if (rootPath != null) {
            String rp = rootPath;
            if (rp.startsWith("/")) {
                rp = rp.substring(1);
            }
            this.rootPath = rp;
        } else {
            this.rootPath = null;
        }
        this.timeout = timeoutMillis;
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMillis);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(schemeRegistry);
        cm.setMaxTotal(200);
        this.client = new MyDefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        NoRetryHttpRequestRetryHandler handler = new NoRetryHttpRequestRetryHandler();
        this.client.setHttpRequestRetryHandler((HttpRequestRetryHandler)handler);
        this.client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                if (super.isRedirected(request, response, context)) {
                    return true;
                }
                int statusCode = response.getStatusLine().getStatusCode();
                String method = request.getRequestLine().getMethod();
                Header locationHeader = response.getFirstHeader("location");
                switch (statusCode) {
                    case 302: {
                        return locationHeader != null && WEBDAV_REDIRECTABLE.contains(method);
                    }
                    case 301: 
                    case 307: {
                        return WEBDAV_REDIRECTABLE.contains(method);
                    }
                }
                return false;
            }
        });
        if (user != null) {
            this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
            PreemptiveAuthInterceptor interceptor = new PreemptiveAuthInterceptor();
            this.client.addRequestInterceptor((HttpRequestInterceptor)interceptor, 0);
        }
        if (proxyDetails != null) {
            if (proxyDetails.isUseSystemProxy()) {
                System.setProperty("java.net.useSystemProxies", "true");
            } else {
                System.setProperty("java.net.useSystemProxies", "false");
                if (proxyDetails.getProxyHost() != null && proxyDetails.getProxyHost().length() > 0) {
                    HttpHost proxy = new HttpHost(proxyDetails.getProxyHost(), proxyDetails.getProxyPort(), "http");
                    this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                    if (proxyDetails.hasAuth()) {
                        this.client.getCredentialsProvider().setCredentials(new AuthScope(proxyDetails.getProxyHost(), proxyDetails.getProxyPort()), (Credentials)new UsernamePasswordCredentials(proxyDetails.getUserName(), proxyDetails.getPassword()));
                    }
                }
            }
        }
        this.transferService = new TransferService((HttpClient)this.client, this.connectionListeners);
        this.transferService.setTimeout(timeoutMillis);
        this.fileSyncer = fileSyncer;
    }

    public Resource find(String path) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        return this.find(path, false);
    }

    public Resource find(String path, boolean invalidateCache) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] arr = path.split("/");
        return Host._find(this, arr, 0, invalidateCache);
    }

    public static Resource _find(Folder parent, String[] arr, int i, boolean invalidateCache) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        String childName = arr[i];
        if (invalidateCache) {
            parent.flush();
        }
        Resource child = parent.child(childName);
        if (i == arr.length - 1) {
            return child;
        }
        if (child instanceof Folder) {
            return Host._find((Folder)child, arr, i + 1, invalidateCache);
        }
        return null;
    }

    public Folder getFolder(String path) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        Resource res = this.find(path);
        if (res instanceof Folder) {
            return (Folder)res;
        }
        throw new RuntimeException("Not a folder: " + res.href());
    }

    public synchronized int doMkCol(Path newUri) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        String url = this.buildEncodedUrl(newUri);
        return this.doMkCol(url);
    }

    public synchronized int doMkCol(String newUri) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        this.notifyStartRequest();
        MkColMethod p = new MkColMethod(newUri);
        try {
            int result = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)p, null, this.newContext());
            if (result == 409) {
                p.abort();
                int n = result;
                return n;
            }
            Utils.processResultCode(result, newUri);
            int n = result;
            return n;
        }
        catch (IOException ex) {
            p.abort();
            throw new RuntimeException(ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public synchronized String doLock(String uri) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        return this.doLock(uri, -1);
    }

    public synchronized String doLock(String uri, int timeout) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        this.notifyStartRequest();
        LockMethod p = new LockMethod(uri, timeout);
        try {
            String lockXml = LOCK_XML.replace("${owner}", this.user);
            StringEntity requestEntity = new StringEntity(lockXml, "UTF-8");
            p.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse resp = this.host().client.execute((HttpUriRequest)p);
            int result = resp.getStatusLine().getStatusCode();
            Utils.processResultCode(result, uri);
            String string = p.getLockToken((HttpResponse)resp);
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public synchronized int doUnLock(String uri, String lockToken) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        this.notifyStartRequest();
        UnLockMethod p = new UnLockMethod(uri, lockToken);
        try {
            int result = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)p, null, this.newContext());
            Utils.processResultCode(result, uri);
            int n = result;
            return n;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public HttpResult doPut(Path path, InputStream content, Long contentLength, String contentType, IfMatchCheck matchCheck) {
        String dest = this.buildEncodedUrl(path);
        return this.doPut(dest, content, contentLength, contentType, matchCheck, null);
    }

    public HttpResult doPut(Path path, byte[] data, String contentType) {
        String dest = this.buildEncodedUrl(path);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        return this.transferService.put(dest, bin, Long.valueOf(data.length), contentType, null, null, this.newContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult doPut(Path remotePath, File file, IfMatchCheck matchCheck, ProgressListener listener) throws FileNotFoundException, HttpException, Utils.CancelledException, NotAuthorizedException, ConflictException {
        HttpResult httpResult;
        if (this.fileSyncer != null) {
            try {
                this.fileSyncer.upload(this, file, remotePath, listener);
                LogUtils.trace((Logger)log, (Object[])new Object[]{"doPut: uploaded"});
                return new HttpResult(Response.Status.SC_OK.code, null);
            }
            catch (NotFoundException e) {
                log.trace("Not found: " + remotePath);
            }
            catch (IOException ex) {
                throw new GenericHttpException(remotePath.toString(), ex);
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String dest = this.buildEncodedUrl(remotePath);
            httpResult = this.doPut(dest, in, file.length(), null, matchCheck, listener);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return httpResult;
    }

    public synchronized HttpResult doPut(String newUri, InputStream content, Long contentLength, String contentType, IfMatchCheck matchCheck, ProgressListener listener) {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"doPut", newUri});
        return this.transferService.put(newUri, content, contentLength, contentType, matchCheck, listener, this.newContext());
    }

    public synchronized int doCopy(String from, String newUri) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        this.notifyStartRequest();
        CopyMethod m = new CopyMethod(from, newUri);
        m.addHeader("Overwrite", "T");
        try {
            int res = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)m, null, this.newContext());
            Utils.processResultCode(res, from);
            int n = res;
            return n;
        }
        catch (HttpException | IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public synchronized int doDelete(Path path) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        String dest = this.buildEncodedUrl(path);
        return this.doDelete(dest);
    }

    public synchronized int doDelete(String url) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.notifyStartRequest();
        HttpDelete m = new HttpDelete(url);
        try {
            int res = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)m, null, this.newContext());
            Utils.processResultCode(res, url);
            int n = res;
            return n;
        }
        catch (HttpException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int doMove(String sourceUrl, String newUri) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException, URISyntaxException {
        this.notifyStartRequest();
        MoveMethod m = new MoveMethod(sourceUrl, newUri);
        try {
            int res = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)m, null, this.newContext());
            Utils.processResultCode(res, sourceUrl);
            int n = res;
            return n;
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public synchronized List<PropFindResponse> propFind(Path path, int depth, QName ... fields) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        ArrayList<QName> list = new ArrayList<QName>(Arrays.asList(fields));
        return this.propFind(path, depth, list);
    }

    public synchronized List<PropFindResponse> propFind(String path, int depth, QName ... fields) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        ArrayList<QName> list = new ArrayList<QName>(Arrays.asList(fields));
        String href = this.baseHref() + this.rootPath + path;
        log.info("propFind: href={}", (Object)href);
        return this._doPropFind(href, depth, list);
    }

    public synchronized List<PropFindResponse> propFind(Path path, int depth, List<QName> fields) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        String url = this.buildEncodedUrl(path);
        return this._doPropFind(url, depth, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<PropFindResponse> _doPropFind(String url, int depth, List<QName> fields) throws IOException, HttpException, NotAuthorizedException, BadRequestException {
        log.info("doPropFind: " + url);
        this.notifyStartRequest();
        PropFindMethod m = new PropFindMethod(url);
        m.addHeader("Depth", depth + "");
        m.addHeader("Accept-Charset", "utf-8,*;q=0.1");
        m.addHeader("Accept", "text/xml");
        try {
            String propFindXml = this.buildPropFindXml(fields);
            StringEntity requestEntity = new StringEntity(propFindXml, "text/xml", "UTF-8");
            m.setEntity((HttpEntity)requestEntity);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ArrayList<PropFindResponse> responses = new ArrayList<PropFindResponse>();
            ResponseHandler respHandler = response -> {
                HttpEntity entity;
                Header serverDateHeader = response.getFirstHeader("Date");
                if (response.getStatusLine().getStatusCode() == 207 && (entity = response.getEntity()) != null) {
                    entity.writeTo((OutputStream)bout);
                    ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                    Document document = this.getResponseAsDocument(bin);
                    String sServerDate = null;
                    if (serverDateHeader != null) {
                        sServerDate = serverDateHeader.getValue();
                    }
                    Date serverDate = null;
                    if (sServerDate != null && sServerDate.length() > 0) {
                        try {
                            serverDate = DateUtils.parseDate((String)sServerDate);
                        }
                        catch (DateUtils.DateParseException ex) {
                            log.warn("Couldnt parse date header: " + sServerDate, (Throwable)ex);
                        }
                    }
                    this.buildResponses(document, serverDate, responses, depth);
                }
                return response.getStatusLine().getStatusCode();
            };
            Integer res = (Integer)this.client.execute((HttpUriRequest)m, respHandler, this.newContext());
            log.info("_doPropFind: result code {}", (Object)res);
            Utils.processResultCode(res, url);
            ArrayList<PropFindResponse> arrayList = responses;
            return arrayList;
        }
        catch (ConflictException | HttpException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotFoundException e) {
            log.trace("not found: " + url);
            List<PropFindResponse> list = null;
            return list;
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    public void buildResponses(Document document, Date serverDate, List<PropFindResponse> responses, int depth) {
        Element root = document.getRootElement();
        List<Element> responseEls = RespUtils.getElements(root, "response");
        boolean isFirst = true;
        for (Element el : responseEls) {
            if (!isFirst || depth == 0) {
                PropFindResponse resp = new PropFindResponse(serverDate, el);
                responses.add(resp);
                continue;
            }
            isFirst = false;
        }
    }

    public Document getResponseAsDocument(InputStream in) throws IOException {
        try {
            return Host.getJDomDocument(in);
        }
        catch (JDOMException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void doGet(String url, StreamReceiver receiver, List<Range> rangeList, ProgressListener listener) throws HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        this.transferService.get(url, receiver, rangeList, listener, this.newContext());
    }

    public synchronized void doGet(Path path, File file, ProgressListener listener) throws IOException, NotFoundException, HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException, ConflictException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"doGet", path});
        if (this.fileSyncer != null) {
            this.fileSyncer.download(this, path, file, listener);
        } else {
            String url = this.buildEncodedUrl(path);
            this.transferService.get(url, in -> {
                FileOutputStream out = null;
                BufferedOutputStream bout = null;
                try {
                    out = FileUtils.openOutputStream((File)file);
                    bout = new BufferedOutputStream(out);
                    IOUtils.copy((InputStream)in, (OutputStream)bout);
                    bout.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bout);
                    IOUtils.closeQuietly((OutputStream)out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)bout);
                IOUtils.closeQuietly((OutputStream)out);
            }, null, listener, this.newContext());
        }
    }

    public synchronized byte[] doGet(Path path) throws IOException, NotFoundException, HttpException, NotAuthorizedException, BadRequestException, ConflictException {
        return this.doGet(path, null);
    }

    public synchronized byte[] doGet(Path path, Map<String, String> queryParams) throws IOException, NotFoundException, HttpException, NotAuthorizedException, BadRequestException, ConflictException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"doGet", path});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.doGet(path, bout, queryParams);
        return bout.toByteArray();
    }

    public synchronized void doGet(Path path, OutputStream out, Map<String, String> queryParams) throws IOException, NotFoundException, HttpException, NotAuthorizedException, BadRequestException, ConflictException {
        String url = this.buildEncodedUrl(path);
        LogUtils.trace((Logger)log, (Object[])new Object[]{"doGet", url});
        if (queryParams != null && queryParams.size() > 0) {
            String qs = Utils.format(queryParams, "UTF-8");
            url = url + "?" + qs;
        }
        this.transferService.get(url, in -> IOUtils.copy((InputStream)in, (OutputStream)out), null, null, this.newContext());
    }

    public synchronized void options(String path) throws ConnectException, NotAuthorizedException, UnknownHostException, SocketTimeoutException, IOException, HttpException, NotFoundException {
        String url = this.encodedUrl() + path;
        this.doOptions(url);
    }

    public void doOptions(Path path) throws NotFoundException, NotAuthorizedException, IOException, HttpException {
        String dest = this.buildEncodedUrl(path);
        this.doOptions(dest);
    }

    private synchronized void doOptions(String url) throws NotFoundException, NotAuthorizedException, IOException, HttpException {
        this.notifyStartRequest();
        log.trace("doOptions: {}", (Object)url);
        HttpOptions m = new HttpOptions(url);
        InputStream in = null;
        try {
            int res = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)m, null, this.newContext());
            log.trace("result code: " + res);
            if (res == 301 || res == 302) {
                return;
            }
            Utils.processResultCode(res, url);
        }
        catch (BadRequestException | ConflictException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Utils.close(in);
            this.notifyFinishRequest();
        }
    }

    public synchronized byte[] get(Path path) throws HttpException, NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        String url = this.buildEncodedUrl(path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.transferService.get(url, in -> {
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }, null, null, this.newContext());
        }
        catch (Utils.CancelledException ex) {
            throw new RuntimeException("Should never happen because no progress listener is set", ex);
        }
        return out.toByteArray();
    }

    public synchronized byte[] get(String path) throws HttpException, NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        String url = this.encodedUrl() + path;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.transferService.get(url, in -> {
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }, null, null, this.newContext());
        }
        catch (Utils.CancelledException ex) {
            throw new RuntimeException("Should never happen because no progress listener is set", ex);
        }
        return out.toByteArray();
    }

    public String doPost(String url, Map<String, String> params) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        UrlEncodedFormEntity entity;
        log.info("POST: url={} timeout={}", (Object)url, (Object)this.timeout);
        this.notifyStartRequest();
        HttpPost m = new HttpPost(url);
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            entity = new UrlEncodedFormEntity(formparams);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        m.setEntity((HttpEntity)entity);
        long tm = System.currentTimeMillis();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int res = Utils.executeHttpWithStatus((HttpClient)this.client, (HttpUriRequest)m, bout, this.newContext());
            Utils.processResultCode(res, url);
            String string = bout.toString();
            return string;
        }
        catch (HttpException ex) {
            tm = System.currentTimeMillis() - tm;
            throw new RuntimeException("RuntimeException URL=" + url + " duration=" + tm, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException URL=" + url + " duration=" + tm, ex);
        }
        finally {
            this.notifyFinishRequest();
        }
    }

    @Override
    public Host host() {
        return this;
    }

    @Override
    public String href() {
        String s = this.baseHref();
        if (this.rootPath != null) {
            s = s + this.rootPath;
        }
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    public String baseHref() {
        String s = "http";
        int defaultPort = 80;
        if (this.secure) {
            s = s + "s";
            defaultPort = 443;
        }
        s = s + "://" + this.server;
        if (this.port != null && this.port != defaultPort && this.port > 0) {
            s = s + ":" + this.port;
        }
        s = s + "/";
        return s;
    }

    public String getHref(Path path) {
        String s = this.href();
        if (!path.isRelative()) {
            s = s.substring(0, s.length() - 1);
        }
        return s + path;
    }

    @Override
    public String encodedUrl() {
        String s = this.buildEncodedUrl(Path.root);
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    public Folder getOrCreateFolder(Path remoteParentPath, boolean create) throws HttpException, IOException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        log.trace("getOrCreateFolder: {}", (Object)remoteParentPath);
        Folder f = this;
        if (remoteParentPath != null) {
            for (String childName : remoteParentPath.getParts()) {
                if (childName.equals("_code")) {
                    f = new Folder(f, childName, (Map<Folder, List<Resource>>)this.cache);
                    continue;
                }
                Resource child = f.child(childName);
                if (child == null) {
                    if (create) {
                        f = f.createFolder(childName);
                        continue;
                    }
                    return null;
                }
                if (child instanceof Folder) {
                    f = (Folder)child;
                    continue;
                }
                log.warn("Can't upload. A resource exists with the same name as a folder, but is a file: " + remoteParentPath + " - " + child.getClass());
                return null;
            }
        }
        return f;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.transferService.setTimeout(timeout);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void addCookie(String name, String value) {
        this.cookies.put(name, value);
    }

    private void notifyStartRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onStartRequest();
        }
    }

    private void notifyFinishRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onFinishRequest();
        }
    }

    public void addConnectionListener(ConnectionListener e) {
        this.connectionListeners.add(e);
    }

    public String buildEncodedUrl(Path path) {
        Path base = Path.path((String)this.rootPath);
        Path p = base.add(path);
        return this.baseHref() + Utils.buildEncodedUrl(p);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public HttpClient getClient() {
        return this.client;
    }

    private String buildPropFindXml(List<QName> fields) {
        try {
            if (fields == null) {
                fields = defaultFields;
            }
            Element elPropfind = new Element("propfind", RespUtils.NS_DAV);
            Document doc = new Document(elPropfind);
            Element elProp = new Element("prop", RespUtils.NS_DAV);
            elPropfind.addContent((Content)elProp);
            for (QName qn : fields) {
                Element elName = new Element(qn.getLocalPart(), qn.getPrefix(), qn.getNamespaceURI());
                elProp.addContent((Content)elName);
            }
            XMLOutputter outputter = new XMLOutputter();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            outputter.output(doc, (OutputStream)out);
            return out.toString("UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isUseDigestForPreemptiveAuth() {
        return this.useDigestForPreemptiveAuth;
    }

    public void setUseDigestForPreemptiveAuth(boolean useDigestForPreemptiveAuth) {
        this.useDigestForPreemptiveAuth = useDigestForPreemptiveAuth;
    }

    public boolean isUsePreemptiveAuth() {
        return this.usePreemptiveAuth;
    }

    public void setUsePreemptiveAuth(boolean usePreemptiveAuth) {
        this.usePreemptiveAuth = usePreemptiveAuth;
    }

    protected HttpContext newContext() {
        BasicHttpContext context = new BasicHttpContext();
        if (this.usePreemptiveAuth) {
            Object authScheme = this.useDigestForPreemptiveAuth ? new DigestScheme() : new BasicScheme();
            context.setAttribute("preemptive-auth", authScheme);
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            BasicClientCookie cookie = new BasicClientCookie(entry.getKey(), entry.getValue());
            cookie.setDomain(this.server);
            cookie.setPath("/");
            cookieStore.addCookie((Cookie)cookie);
        }
        context.setAttribute("http.cookie-store", (Object)cookieStore);
        return context;
    }

    static class MyDefaultHttpClient
    extends DefaultHttpClient {
        public MyDefaultHttpClient(ClientConnectionManager cm, HttpParams params) {
            super(cm, params);
        }

        protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
            return new NoRetryHttpRequestRetryHandler();
        }

        protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
            return super.createClientRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthHandler, proxyAuthHandler, stateHandler, params);
        }
    }

    static class NoRetryHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        NoRetryHttpRequestRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private String nonce;
        private String realm;

        public void process(HttpRequest request, HttpContext context) {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                if (authScheme != null) {
                    boolean canDoAuth = false;
                    if (authScheme instanceof DigestScheme) {
                        DigestScheme d = (DigestScheme)authScheme;
                        if (this.nonce != null) {
                            d.overrideParamter("nonce", this.nonce);
                        }
                        if (this.realm != null) {
                            d.overrideParamter("realm", this.realm);
                            canDoAuth = true;
                        }
                    } else if (authScheme instanceof BasicScheme) {
                        canDoAuth = true;
                    }
                    if (canDoAuth) {
                        HttpHost targetHost;
                        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                        Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                        if (creds == null) {
                            throw new RuntimeException("No credentials for preemptive authentication");
                        }
                        authState.setAuthScheme(authScheme);
                        authState.setCredentials(creds);
                    }
                }
            } else if (authState.getAuthScheme() instanceof DigestScheme) {
                DigestScheme scheme = (DigestScheme)authState.getAuthScheme();
                this.nonce = scheme.getParameter("nonce");
                this.realm = scheme.getParameter("realm");
            }
        }
    }
}

