/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.ChecksumPair;
import io.milton.zsync.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Generator {
    public List generateSums(byte[] buf, long baseOffset, Configuration config) {
        return this.generateSums(buf, 0, buf.length, baseOffset, config);
    }

    private List generateSums(byte[] buf, int off, int len, long baseOffset, Configuration config) {
        int count = (len + (config.blockLength - 1)) / config.blockLength;
        int remainder = len % config.blockLength;
        int offset = off;
        ArrayList<ChecksumPair> sums = new ArrayList<ChecksumPair>(count);
        int i = 0;
        while (i < count) {
            int n = Math.min(len, config.blockLength);
            ChecksumPair pair = this.generateSum(buf, offset, n, (long)offset + baseOffset, config);
            pair.seq = i++;
            sums.add(pair);
            len -= n;
            offset += n;
        }
        return sums;
    }

    public List generateSums(File f, Configuration config) throws IOException {
        int l;
        long len = f.length();
        int count = (int)((len + (long)(config.blockLength + 1)) / (long)config.blockLength);
        long offset = 0L;
        FileInputStream fin = new FileInputStream(f);
        ArrayList<ChecksumPair> sums = new ArrayList<ChecksumPair>(count);
        int n = config.blockLength;
        byte[] buf = new byte[n];
        for (int i = 0; i < count && (l = fin.read(buf, 0, n)) != -1; ++i) {
            if (n < config.blockLength) {
                Arrays.fill(buf, n, config.blockLength, (byte)0);
            }
            if (l <= 0) continue;
            ChecksumPair pair = this.generateSum(buf, 0, config.blockLength, offset, config);
            pair.seq = i;
            sums.add(pair);
            offset += (long)n;
            n = (int)Math.min(len -= (long)n, (long)config.blockLength);
        }
        fin.close();
        return sums;
    }

    public List generateSums(InputStream in, Configuration config, MessageDigest sha1) throws IOException, NoSuchAlgorithmException {
        List sums = null;
        byte[] buf = new byte[config.blockLength * config.blockLength];
        long offset = 0L;
        int len = 0;
        while ((len = in.read(buf)) != -1) {
            sha1.update(buf, 0, len);
            if (sums == null) {
                sums = this.generateSums(buf, 0, len, offset, config);
            } else {
                sums.addAll(this.generateSums(buf, 0, len, offset, config));
            }
            offset += (long)len;
        }
        return sums;
    }

    public ChecksumPair generateSum(byte[] buf, long fileOffset, Configuration config) {
        return this.generateSum(buf, 0, buf.length, fileOffset, config);
    }

    public ChecksumPair generateSum(byte[] buf, int off, int len, long fileOffset, Configuration config) {
        ChecksumPair p = new ChecksumPair();
        config.weakSum.check(buf, off, len);
        config.strongSum.update(buf, off, len);
        if (config.checksumSeed != null) {
            config.strongSum.update(config.checksumSeed, 0, config.checksumSeed.length);
        }
        p.weak = config.weakSum.getValue();
        p.strong = new byte[config.strongSumLength];
        System.arraycopy(config.strongSum.digest(), 0, p.strong, 0, p.strong.length);
        p.offset = fileOffset;
        p.length = len;
        return p;
    }

    public int generateWeakSum(byte[] buf, int offset, Configuration config) {
        config.weakSum.first(buf, offset, config.blockLength);
        return config.weakSum.getValue();
    }

    public int generateRollSum(byte b, Configuration config) {
        config.weakSum.roll(b);
        return config.weakSum.getValue();
    }

    public byte[] generateStrongSum(byte[] buf, int off, int len, Configuration config) {
        config.strongSum.update(buf, off, len);
        byte[] strongSum = new byte[config.strongSumLength];
        System.arraycopy(config.strongSum.digest(), 0, strongSum, 0, strongSum.length);
        return strongSum;
    }
}

