/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.http.Range;
import io.milton.httpclient.zsyncclient.RangeLoader;
import io.milton.zsync.FileDownloader;
import io.milton.zsync.FileUpdater;
import io.milton.zsync.MakeContext;
import io.milton.zsync.MapMatcher;
import io.milton.zsync.MetaFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMaker {
    private static final Logger log = LoggerFactory.getLogger(FileMaker.class);
    private final MapMatcher mapMatcher = new MapMatcher();
    private final FileUpdater fileUpdater = new FileUpdater();
    private final FileDownloader fileDownloader = new FileDownloader();

    public File make(File inputFile, File metafile, RangeLoader rangeLoader) throws Exception {
        MetaFileReader mfr = new MetaFileReader(metafile);
        return this.make(mfr, inputFile, rangeLoader);
    }

    private File make(MetaFileReader mfr, File inputFile, RangeLoader rangeLoader) throws Exception {
        MakeContext makeContext = new MakeContext(mfr.getHashtable(), new long[mfr.getBlockCount()]);
        Arrays.fill(makeContext.fileMap, -1L);
        double complete = this.mapMatcher.mapMatcher(inputFile, mfr, makeContext);
        File dest = null;
        dest = File.createTempFile("zsyncM_", "_" + inputFile.getName());
        if (complete == 0.0) {
            log.info("local file has no corresponding blocks, so download whole file");
            this.fileDownloader.downloadWholeFile(rangeLoader, dest);
        } else {
            this.fileUpdater.update(inputFile, mfr, rangeLoader, makeContext, dest);
        }
        return dest;
    }

    public List<Range> findMissingRanges(File inputFile, File metafile) throws Exception {
        MetaFileReader mfr = new MetaFileReader(metafile);
        MakeContext mc = new MakeContext(mfr.getHashtable(), new long[mfr.getBlockCount()]);
        Arrays.fill(mc.fileMap, -1L);
        double complete = this.mapMatcher.mapMatcher(inputFile, mfr, mc);
        if (complete == 0.0) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        int blocksize = mfr.getBlocksize();
        for (int i = 0; i < mc.fileMap.length; ++i) {
            if (mc.fileMap[i] != -1L) continue;
            ranges.add(new Range(Long.valueOf(i * blocksize), Long.valueOf((long)(i * blocksize) + (long)blocksize)));
        }
        return ranges;
    }
}

