/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.http.Range;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangedGetMethod
extends HttpRequestBase {
    private static final Logger log = LoggerFactory.getLogger(RangedGetMethod.class);

    public RangedGetMethod(String uri, List<Range> dataRanges) throws URISyntaxException {
        this.setURI(new URI(uri));
        if (dataRanges != null && !dataRanges.isEmpty()) {
            String rangeHeaderVal = this.getRangesRequest(dataRanges);
            log.info("ranges: " + rangeHeaderVal);
            this.setHeader("Range", "bytes=" + rangeHeaderVal);
        } else {
            log.info("No ranges to get");
        }
    }

    private String getRangesRequest(List<Range> ranges) {
        StringBuilder sb = new StringBuilder();
        for (Range d : ranges) {
            sb.append(d.getRange()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public String getMethod() {
        return "GET";
    }
}

