/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.http.values.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpResult {
    private final int statusCode;
    private final List<Pair<String, String>> allHeaders;
    private Map<String, String> headers;

    public HttpResult(int statusCode, List<Pair<String, String>> allHeaders) {
        this.statusCode = statusCode;
        this.allHeaders = allHeaders;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
            for (Pair<String, String> p : this.allHeaders) {
                this.headers.put((String)p.getObject1(), (String)p.getObject2());
            }
        }
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<String> getHeaderValues(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (Pair<String, String> h : this.allHeaders) {
            if (!((String)h.getObject1()).equals(name)) continue;
            list.add((String)h.getObject2());
        }
        return list;
    }
}

