/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1 {
    private final File file;
    private FileInputStream fis;
    private MessageDigest sha1;

    public SHA1(String filename) {
        this.file = new File(filename);
    }

    public SHA1(File file) {
        this.file = file;
    }

    public String SHA1sum() {
        try {
            this.sha1 = MessageDigest.getInstance("SHA1");
            this.fis = new FileInputStream(this.file);
            byte[] dataBytes = new byte[1024];
            int read = 0;
            while ((read = this.fis.read(dataBytes)) != -1) {
                this.sha1.update(dataBytes, 0, read);
            }
            return SHA1.toString(this.sha1);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read file to count SHA-1 hash, check your permissions", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Problem with SHA-1 hash", ex);
        }
    }

    public static String toString(MessageDigest sha1) {
        byte[] mdbytes = sha1.digest();
        StringBuilder sb = new StringBuilder();
        for (byte mdbyte : mdbytes) {
            sb.append(Integer.toString((mdbyte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

