/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.ChainingHash;
import io.milton.zsync.ChecksumPair;
import io.milton.zsync.HeaderMaker;
import io.milton.zsync.MetaFileMaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MetaFileReader {
    private ChainingHash hashtable;
    private int fileOffset;
    private final int blockNum;
    private HeaderMaker.Headers headers;

    public MetaFileReader(File metafile) {
        this.readMetaFile(metafile);
        this.blockNum = (int)Math.ceil((double)this.headers.length / (double)this.headers.blocksize);
        this.readChecksums(metafile);
    }

    public MetaFileReader(MetaFileMaker.MetaData metaData) {
        this.headers = metaData.getHeaders();
        this.blockNum = (int)Math.ceil((double)this.headers.length / (double)this.headers.blocksize);
        this.fillHashTable(metaData.getChecksums());
    }

    private boolean parseHeader(String s) {
        if (s.equals("")) {
            return true;
        }
        int colonIndex = s.indexOf(":");
        String subs = s.substring(0, colonIndex);
        if (subs.equalsIgnoreCase("zsync")) {
            this.headers.version = s.substring(colonIndex + 2);
            if (this.headers.version.equals("0.0.4") || this.headers.version.equals("0.0.2")) {
                throw new RuntimeException("This version is not compatible with zsync streams in versions up to 0.0.4");
            }
        } else if (subs.equalsIgnoreCase("Blocksize")) {
            this.headers.blocksize = Integer.parseInt(s.substring(colonIndex + 2));
        } else if (subs.equalsIgnoreCase("Length")) {
            this.headers.length = Long.parseLong(s.substring(colonIndex + 2));
        } else if (subs.equalsIgnoreCase("Hash-Lengths")) {
            int comma = s.indexOf(",");
            int seqNum = Integer.parseInt(s.substring(colonIndex + 2, comma));
            this.headers.setSeqNum(seqNum);
            int nextComma = s.indexOf(",", comma + 1);
            this.headers.setRsumBytes(Integer.parseInt(s.substring(comma + 1, nextComma)));
            this.headers.setChecksumBytes(Integer.parseInt(s.substring(nextComma + 1)));
            if (this.headers.getSeqNum() < 1 || this.headers.getSeqNum() > 2 || this.headers.getRsumButes() < 1 || this.headers.getRsumButes() > 4 || this.headers.getChecksumBytes() < 3 || this.headers.getChecksumBytes() > 16) {
                throw new RuntimeException("Nonsensical hash lengths line " + s.substring(colonIndex + 2));
            }
        } else if (subs.equalsIgnoreCase("URL")) {
            this.headers.url = s.substring(colonIndex + 2);
        } else if (!subs.equalsIgnoreCase("Z-URL")) {
            if (subs.equalsIgnoreCase("SHA-1")) {
                this.headers.sha1 = s.substring(colonIndex + 2);
            } else if (subs.equalsIgnoreCase("Z-Map2")) {
                // empty if block
            }
        }
        return false;
    }

    private void readMetaFile(File metafile) {
        this.headers = new HeaderMaker.Headers();
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(metafile));
            while ((s = in.readLine()) != null && !this.parseHeader(s)) {
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + metafile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO problem in metafile header reading", e);
        }
    }

    private void readChecksums(File metafile) {
        long length = metafile.length();
        if (metafile.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Metafile is too large");
        }
        byte[] bytes = new byte[(int)length];
        try {
            int offset;
            FileInputStream is = new FileInputStream(metafile);
            int n = 0;
            for (offset = 0; offset < bytes.length && (n = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += n) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + metafile.getName());
            }
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new RuntimeException("IO problem in metafile reading", e);
        }
        this.fileOffset = 0;
        for (int i = 2; i < bytes.length; ++i) {
            if (bytes[i - 2] != 10 || bytes[i - 1] != 10) continue;
            this.fileOffset = i;
            break;
        }
        this.fillHashTable(bytes);
    }

    private void fillHashTable(List<ChecksumPair> list) {
        int i;
        for (i = 16; 2 << i - 1 > this.blockNum && i > 4; --i) {
        }
        this.hashtable = new ChainingHash(2 << i - 1);
        for (ChecksumPair pair : list) {
            this.hashtable.insert(pair);
        }
    }

    private void fillHashTable(byte[] checksums) {
        int i;
        for (i = 16; 2 << i - 1 > this.blockNum && i > 4; --i) {
        }
        this.hashtable = new ChainingHash(2 << i - 1);
        ChecksumPair p = null;
        int offset = 0;
        int weakSum = 0;
        int off = this.fileOffset;
        byte[] weak = new byte[4];
        byte[] strongSum = new byte[this.headers.getChecksumBytes()];
        for (int seq = 0; seq < this.blockNum; ++seq) {
            for (int w = 0; w < this.headers.getRsumButes(); ++w) {
                weak[w] = checksums[off];
                ++off;
            }
            for (int s = 0; s < strongSum.length; ++s) {
                strongSum[s] = checksums[off];
                ++off;
            }
            weakSum = 0;
            weakSum += (weak[2] & 0xFF) << 24;
            weakSum += (weak[3] & 0xFF) << 16;
            weakSum += (weak[0] & 0xFF) << 8;
            p = new ChecksumPair(weakSum += weak[1] & 0xFF, (byte[])strongSum.clone(), offset, this.headers.blocksize, seq);
            offset += this.headers.blocksize;
            this.hashtable.insert(p);
        }
    }

    public ChainingHash getHashtable() {
        return this.hashtable;
    }

    public int getBlockCount() {
        return this.blockNum;
    }

    public int getBlocksize() {
        return this.headers.blocksize;
    }

    public int getChecksumBytes() {
        return this.headers.getChecksumBytes();
    }

    public long getLength() {
        return this.headers.length;
    }

    public int getRsumBytes() {
        return this.headers.getRsumButes();
    }

    public int getSeqNum() {
        return this.headers.getSeqNum();
    }

    public String getSha1() {
        return this.headers.sha1;
    }
}

