/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.BufferingOutputStream;
import io.milton.common.RangeUtils;
import io.milton.http.Range;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class DataRange {
    public static final int threshold = 0x100000;
    private final Range range;
    private final BufferingOutputStream data;

    public DataRange(Range range, InputStream instream) throws IOException {
        this.range = range;
        this.data = new BufferingOutputStream(0x100000);
        long length = range.getFinish() - range.getStart();
        RangeUtils.sendBytes((InputStream)instream, (OutputStream)this.data, (long)length);
        this.data.close();
    }

    public DataRange(Range range, RandomAccessFile randAccess) throws IOException {
        this.range = range;
        this.data = new BufferingOutputStream(0x100000);
        randAccess.seek(range.getStart());
        long length = range.getFinish() - range.getStart();
        byte[] buffer = new byte[2048];
        int bytesLeft = (int)length;
        int bytesRead = Math.min(bytesLeft, buffer.length);
        while (bytesLeft > 0) {
            randAccess.read(buffer, 0, bytesRead);
            this.data.write(buffer, 0, bytesRead);
            bytesRead = Math.min(bytesLeft -= bytesRead, buffer.length);
        }
        this.data.close();
    }

    public String toString() {
        return this.range.toString();
    }

    public Range getRange() {
        return this.range;
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public long getLength() {
        return this.range.getFinish() - this.range.getStart();
    }
}

