/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.common.LogUtils;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.ConnectionListener;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.HttpResult;
import io.milton.httpclient.IfMatchCheck;
import io.milton.httpclient.NotifyingFileInputStream;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.RangedGetMethod;
import io.milton.httpclient.StreamReceiver;
import io.milton.httpclient.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferService {
    private static final Logger log = LoggerFactory.getLogger(TransferService.class);
    private final HttpClient client;
    private final List<ConnectionListener> connectionListeners;
    private int timeout;

    public TransferService(HttpClient client, List<ConnectionListener> connectionListeners) {
        this.client = client;
        this.connectionListeners = connectionListeners;
    }

    public synchronized void get(String url, StreamReceiver receiver, List<Range> rangeList, ProgressListener listener, HttpContext context) throws HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        Object m;
        LogUtils.trace((Logger)log, (Object[])new Object[]{"get: ", url});
        this.notifyStartRequest();
        if (rangeList != null) {
            try {
                m = new RangedGetMethod(url, rangeList);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            m = new HttpGet(url);
        }
        InputStream in = null;
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)m, context);
            if (resp.getEntity() == null) {
                log.warn("Did not receive a response entity for GET");
                return;
            }
            HttpEntity entity = resp.getEntity();
            in = entity.getContent();
            Utils.processResultCode(resp.getStatusLine().getStatusCode(), url);
            NotifyingFileInputStream nin = new NotifyingFileInputStream(in, entity.getContentLength(), url, listener);
            receiver.receive(nin);
            Utils.close(in);
            this.notifyFinishRequest();
        }
        catch (Utils.CancelledException ex) {
            m.abort();
            throw ex;
        }
        catch (IOException ex) {
            m.abort();
            throw new RuntimeException(ex);
        }
        finally {
            Utils.close(in);
            this.notifyFinishRequest();
        }
    }

    public HttpResult put(String encodedUrl, InputStream content, Long contentLength, String contentType, IfMatchCheck etagMatch, ProgressListener listener, HttpContext context) {
        HttpResult httpResult;
        LogUtils.trace((Logger)log, (Object[])new Object[]{"put: ", encodedUrl});
        this.notifyStartRequest();
        HttpPut p = new HttpPut(encodedUrl);
        p.addHeader(Request.Header.CONTENT_TYPE.code, contentType);
        p.addHeader(Request.Header.OVERWRITE.code, "T");
        if (etagMatch != null) {
            if (etagMatch.getEtag() != null) {
                p.addHeader(Request.Header.IF_MATCH.code, etagMatch.getEtag());
            } else {
                p.addHeader(Request.Header.IF_NONE_MATCH.code, "*");
            }
        }
        NotifyingFileInputStream notifyingIn = null;
        try {
            notifyingIn = new NotifyingFileInputStream(content, contentLength, encodedUrl, listener);
            if (contentLength == null) {
                throw new RuntimeException("Content length for input stream is null, you must provide a length");
            }
            InputStreamEntity requestEntity = new InputStreamEntity((InputStream)notifyingIn, contentLength.longValue());
            requestEntity = new BufferedHttpEntity((HttpEntity)requestEntity);
            p.setEntity((HttpEntity)requestEntity);
            httpResult = Utils.executeHttpWithResult(this.client, (HttpUriRequest)p, null, context);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(notifyingIn);
                this.notifyFinishRequest();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)notifyingIn);
        this.notifyFinishRequest();
        return httpResult;
    }

    private void notifyStartRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onStartRequest();
        }
    }

    private void notifyFinishRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onFinishRequest();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

