/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.http.Range;
import java.text.ParseException;

public final class RelocateRange {
    public static final String DIV = "/";
    private final Range blockRange;
    private final long newOffset;

    public RelocateRange(Range range, long offset) {
        this.blockRange = range;
        this.newOffset = offset;
    }

    public String toString() {
        return "Relocate blocks " + this.blockRange.getRange() + " to " + this.newOffset;
    }

    public String getRelocation() {
        return this.blockRange.getRange() + DIV + this.newOffset;
    }

    public static RelocateRange parse(String relocString) throws ParseException {
        String[] parts = relocString.split(DIV);
        if (parts.length != 2) {
            throw new ParseException("Couldn't parse: \"" + relocString + "\" as RelocateRange. String contains " + (parts.length - 1) + " occurences of " + DIV, -1);
        }
        try {
            Range range = Range.parse((String)parts[0].trim());
            long loc = Long.parseLong(parts[1].trim());
            return new RelocateRange(range, loc);
        }
        catch (Exception ex) {
            ParseException parseEx = new ParseException("Couldn't parse \"" + relocString + "\" into a RelocateRange. Format should be A-B/C, with no whitespaces", -1);
            parseEx.initCause(ex);
            throw parseEx;
        }
    }

    public Range getBlockRange() {
        return this.blockRange;
    }

    public long getOffset() {
        return this.newOffset;
    }
}

