/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.ChecksumPair;
import io.milton.zsync.Configuration;
import io.milton.zsync.Generator;
import io.milton.zsync.HeaderMaker;
import io.milton.zsync.JarsyncProvider;
import io.milton.zsync.Rsum;
import io.milton.zsync.SHA1;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MetaFileMaker {
    private final int STRONG_SUM_LENGTH = 16;
    private final HeaderMaker headerMaker = new HeaderMaker();
    private final Generator gen = new Generator();

    public MetaData make(String url, int blocksize, long fileLength, Date lastMod, InputStream fileData) {
        int[] hashLengths = this.analyzeFile(blocksize, fileLength);
        HeaderMaker.Headers headers = this.headerMaker.getFullHeader(lastMod, fileLength, url, blocksize, hashLengths, null);
        try {
            Configuration config = new Configuration();
            config.strongSum = MessageDigest.getInstance("MD4");
            config.weakSum = new Rsum();
            config.blockLength = blocksize;
            config.strongSumLength = hashLengths[2];
            ArrayList<ChecksumPair> list = new ArrayList((int)Math.ceil((double)fileLength / (double)blocksize));
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA1");
            list = this.gen.generateSums(fileData, config, sha1Digest);
            headers.sha1 = SHA1.toString(sha1Digest);
            return new MetaData(headers, list);
        }
        catch (IOException | NoSuchAlgorithmException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * Exception decompiling
     */
    public File make(String url, int blocksize, File file) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(MetaData metaData, OutputStream out) {
        String header = this.headerMaker.toString(metaData.getHeaders());
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out);
            BufferedWriter writer = new BufferedWriter(osw);
            writer.write(header);
            writer.flush();
            osw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldnt write zsync headers", e);
        }
        try {
            List<ChecksumPair> list = metaData.getChecksums();
            for (ChecksumPair p : list) {
                int rsum_bytes = ((MetaData)metaData).headers.hashLengths[1];
                out.write(this.intToBytes(p.getWeak(), rsum_bytes));
                out.write(p.getStrong());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private int[] analyzeFile(int blocksize, long fileLength) {
        int[] hashLengths = new int[3];
        hashLengths[2] = 16;
        hashLengths[0] = fileLength > (long)blocksize ? 2 : 1;
        hashLengths[1] = (int)Math.ceil(((Math.log(fileLength) + Math.log(blocksize)) / Math.log(2.0) - 8.6) / 8.0);
        if (hashLengths[1] > 4) {
            hashLengths[1] = 4;
        }
        if (hashLengths[1] < 2) {
            hashLengths[1] = 2;
        }
        hashLengths[2] = (int)Math.ceil((20.0 + (Math.log(fileLength) + Math.log(1L + fileLength / (long)blocksize)) / Math.log(2.0)) / (double)hashLengths[0] / 8.0);
        int strongSumLength2 = (int)((7.9 + (20.0 + Math.log(1L + fileLength / (long)blocksize) / Math.log(2.0))) / 8.0);
        if (hashLengths[2] < strongSumLength2) {
            hashLengths[2] = strongSumLength2;
        }
        return hashLengths;
    }

    private byte[] intToBytes(int number, int rsum_bytes) {
        byte[] rsum = new byte[rsum_bytes];
        switch (rsum_bytes) {
            case 2: {
                rsum = new byte[]{(byte)(number >> 24), (byte)(number << 8 >> 24)};
                break;
            }
            case 3: {
                rsum = new byte[]{(byte)(number << 24 >> 24), (byte)(number >> 24), (byte)(number << 8 >> 24)};
                break;
            }
            case 4: {
                rsum = new byte[]{(byte)(number << 16 >> 24), (byte)(number << 24 >> 24), (byte)(number >> 24), (byte)(number << 8 >> 24)};
            }
        }
        return rsum;
    }

    public int computeBlockSize(long fileLength) {
        int blocksize = 512;
        int[][] array = new int[10][2];
        array[0][0] = 2048;
        array[0][1] = 2048;
        for (int i = 1; i < array.length; ++i) {
            array[i][0] = array[i - 1][0] * 2;
            array[i][1] = array[i][0];
        }
        long constant = fileLength / 50000L;
        for (int[] item : array) {
            item[0] = (int)Math.abs((long)item[0] - constant);
        }
        int min = array[0][0];
        for (int[] item : array) {
            if (item[0] >= min) continue;
            min = item[0];
        }
        for (int[] item : array) {
            if (item[0] != min) continue;
            blocksize = item[1];
        }
        return blocksize;
    }

    static {
        Security.addProvider(new JarsyncProvider());
    }

    public static class MetaData {
        private final HeaderMaker.Headers headers;
        private final List<ChecksumPair> list;

        public MetaData(HeaderMaker.Headers headers, List<ChecksumPair> list) {
            this.headers = headers;
            this.list = list;
        }

        public HeaderMaker.Headers getHeaders() {
            return this.headers;
        }

        public List<ChecksumPair> getChecksums() {
            return this.list;
        }
    }
}

