/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.RollingChecksum;
import java.io.Serializable;

public class Rsum
implements RollingChecksum,
Cloneable,
Serializable {
    private short a = 0;
    private short b = 0;
    private int oldByte = 0;
    private int blockLength;
    private byte[] buffer;

    @Override
    public int getValue() {
        return this.a & 0xFFFF | this.b << 16;
    }

    @Override
    public void reset() {
        this.b = 0;
        this.a = 0;
        this.oldByte = 0;
    }

    @Override
    public void roll(byte newByte) {
        short oldUnsignedB = this.unsignedByte(this.buffer[this.oldByte]);
        this.a = (short)(this.a - oldUnsignedB);
        this.b = (short)(this.b - this.blockLength * oldUnsignedB);
        this.a = (short)(this.a + this.unsignedByte(newByte));
        this.b = (short)(this.b + this.a);
        this.buffer[this.oldByte] = newByte;
        ++this.oldByte;
        if (this.oldByte == this.blockLength) {
            this.oldByte = 0;
        }
    }

    @Override
    public void check(byte[] buf, int offset, int length) {
        this.reset();
        int index = offset;
        for (int i = length; i > 0; --i) {
            short unsignedB = this.unsignedByte(buf[index]);
            this.a = (short)(this.a + unsignedB);
            this.b = (short)(this.b + i * unsignedB);
            ++index;
        }
    }

    @Override
    public void first(byte[] buf, int offset, int length) {
        this.reset();
        int index = offset;
        for (int i = length; i > 0; --i) {
            short unsignedB = this.unsignedByte(buf[index]);
            this.a = (short)(this.a + unsignedB);
            this.b = (short)(this.b + i * unsignedB);
            ++index;
        }
        this.blockLength = length;
        this.buffer = new byte[this.blockLength];
        System.arraycopy(buf, 0, this.buffer, 0, length);
    }

    private short unsignedByte(byte b) {
        if (b < 0) {
            return (short)(b + 256);
        }
        return b;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error();
        }
    }

    @Override
    public boolean equals(Object o) {
        return ((Rsum)o).a == this.a && ((Rsum)o).b == this.b;
    }
}

