/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.ChainingHash;
import io.milton.zsync.ChecksumPair;
import io.milton.zsync.MakeContext;
import io.milton.zsync.OffsetPair;
import java.util.LinkedList;
import java.util.List;

public class MakeContextEx
extends MakeContext {
    private final List<OffsetPair>[] matchMap;
    private long nextOffset;
    private final int blocksize;

    public MakeContextEx(ChainingHash hashtable, int blockcount, int blocksize) {
        super(hashtable, null);
        this.matchMap = new LinkedList[blockcount];
        this.blocksize = blocksize;
        this.nextOffset = 0L;
    }

    public List<OffsetPair> getReverseMap() {
        LinkedList<OffsetPair> reverseMap = new LinkedList<OffsetPair>();
        for (List<OffsetPair> item : this.matchMap) {
            if (item == null) continue;
            reverseMap.addAll(item);
        }
        return reverseMap;
    }

    @Override
    public void put(int blockIndex, long offset) {
        if (blockIndex >= this.matchMap.length - 1) {
            return;
        }
        if (offset < this.nextOffset) {
            return;
        }
        if (this.matchMap[blockIndex] == null) {
            this.matchMap[blockIndex] = new LinkedList<OffsetPair>();
        }
        this.matchMap[blockIndex].add(new OffsetPair(offset, blockIndex));
        this.nextOffset = offset + (long)this.blocksize;
    }

    @Override
    public void delete(ChecksumPair key) {
    }

    @Override
    public boolean matched(int blockIndex) {
        if (blockIndex > 0 && blockIndex < this.blockcount()) {
            return this.matchMap[blockIndex] != null;
        }
        return false;
    }

    @Override
    public void removematch(int blockIndex) {
        if (blockIndex > 0 && blockIndex < this.blockcount()) {
            this.matchMap[blockIndex] = null;
        }
    }

    @Override
    public int blockcount() {
        return this.matchMap.length;
    }
}

