/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.Range;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.Folder;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.HttpResult;
import io.milton.httpclient.IfMatchCheck;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.PropFindResponse;
import io.milton.httpclient.Resource;
import io.milton.httpclient.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(File.class);
    public final String contentType;
    public Long contentLength;
    private String etag;

    public File(Folder parent, PropFindResponse resp) {
        super(parent, resp);
        this.contentType = resp.getContentType();
        this.contentLength = resp.getContentLength();
        this.etag = resp.getEtag();
    }

    public File(Folder parent, String name, String contentType, Long contentLength, String etag) {
        super(parent, name);
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.etag = etag;
    }

    public void setContent(InputStream in, Long contentLength, ProgressListener listener) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        String newUri = this.encodedUrl();
        log.trace("upload: " + newUri);
        HttpResult result = this.host().doPut(newUri, in, contentLength, this.contentType, new IfMatchCheck(this.etag), listener);
        this.etag = result.getHeaders().get(Response.Header.ETAG.code);
        int resultCode = result.getStatusCode();
        Utils.processResultCode(resultCode, newUri);
        this.contentLength = contentLength;
    }

    @Override
    public String toString() {
        return super.toString() + " (content type=" + this.contentType + ")";
    }

    @Override
    public java.io.File downloadTo(java.io.File destFolder, ProgressListener listener) throws IOException, HttpException {
        if (!destFolder.exists()) {
            throw new FileNotFoundException(destFolder.getAbsolutePath());
        }
        java.io.File dest = destFolder.isFile() ? destFolder : new java.io.File(destFolder, this.name);
        this.downloadToFile(dest, listener);
        return dest;
    }

    public void downloadToFile(java.io.File dest, ProgressListener listener) throws FileNotFoundException, HttpException, Utils.CancelledException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"downloadToFile", this.name});
        if (listener != null) {
            listener.onProgress(0L, dest.length(), this.name);
        }
        try {
            Path path = this.path();
            this.host().doGet(path, dest, listener);
        }
        catch (Utils.CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (listener != null) {
            long length = dest.length();
            listener.onProgress(length, length, this.name);
            listener.onComplete(this.name);
        }
    }

    public void download(OutputStream out, ProgressListener listener) throws HttpException, Utils.CancelledException {
        this.download(out, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(OutputStream out, ProgressListener listener, List<Range> rangeList) throws HttpException, Utils.CancelledException {
        if (listener != null) {
            listener.onProgress(0L, null, this.name);
        }
        long[] bytesArr = new long[1];
        try {
            this.host().doGet(this.encodedUrl(), in -> {
                long bytes;
                if (listener != null && listener.isCancelled()) {
                    throw new RuntimeException("Download cancelled");
                }
                bytesArr[0] = bytes = Utils.write(in, out, listener);
            }, rangeList, listener);
        }
        catch (Utils.CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
        }
        finally {
            Utils.close(out);
        }
        if (listener != null) {
            long l = bytesArr[0];
            listener.onProgress(l, l, this.name);
            listener.onComplete(this.name);
        }
    }

    @Override
    public String encodedUrl() {
        return this.parent.encodedUrl() + this.encodedName();
    }

    public String getEtag() {
        return this.etag;
    }
}

