/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.BufferingOutputStream;
import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.common.StreamUtils;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.DigestResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.ReplaceableResource;
import io.milton.resource.Resource;
import io.milton.zsync.MetaFileMaker;
import io.milton.zsync.SHA1;
import io.milton.zsync.UploadReader;
import io.milton.zsync.ZSyncResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZSyncResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(ZSyncResourceFactory.class);
    private String suffix = ".zsync";
    private final ResourceFactory wrapped;
    private final MetaFileMaker metaFileMaker;
    private final int defaultBlockSize = 512;
    private final int maxMemorySize = 100000;

    public ZSyncResourceFactory(ResourceFactory wrapped) {
        this.wrapped = wrapped;
        this.metaFileMaker = new MetaFileMaker();
    }

    public Resource getResource(String host, String path) throws NotAuthorizedException, BadRequestException {
        if (path.endsWith("/" + this.suffix)) {
            Path p = Path.path((String)path);
            String realPath = p.getParent().toString();
            Resource r = this.wrapped.getResource(host, realPath);
            if (r == null) {
                return new ZSyncAdapterResource(null, realPath, host);
            }
            if (r instanceof GetableResource) {
                LogUtils.trace((Logger)log, (Object[])new Object[]{"Found existing compatible resource at", realPath});
                return new ZSyncAdapterResource((GetableResource)r, realPath, host);
            }
            return new ZSyncAdapterResource(null, realPath, host);
        }
        return this.wrapped.getResource(host, path);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public ResourceFactory getWrapped() {
        return this.wrapped;
    }

    public class ZSyncAdapterResource
    implements GetableResource,
    ReplaceableResource,
    DigestResource {
        private final GetableResource r;
        private final String realPath;
        private final String host;
        private List<Range> ranges;

        public ZSyncAdapterResource(GetableResource r, String realPath, String host) {
            this.r = r;
            this.realPath = realPath;
            this.host = host;
        }

        public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
            if (this.r == null) {
                throw new BadRequestException((Resource)this, "No existing resource was found to map the zsync operation to");
            }
            if (this.ranges != null) {
                log.info("sendContent: sending range data");
                this.sendRangeData(out);
            } else {
                log.info("sendContent: sending meta data");
                this.sendMetaData(params, contentType, out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceContent(InputStream in, Long length) throws BadRequestException, ConflictException, NotAuthorizedException {
            if (this.r == null) {
                throw new BadRequestException((Resource)this, "No existing resource was found to map the zsync operation to");
            }
            log.trace("ZSync Replace Content: uploaded bytes " + length);
            try {
                File prevFile = File.createTempFile("milton-zsync", "prevFile");
                FileOutputStream fout = new FileOutputStream(prevFile);
                this.r.sendContent((OutputStream)fout, null, null, null);
                StreamUtils.close((OutputStream)fout);
                log.trace("Saved previous file to " + prevFile.getAbsolutePath());
                File uploadData = File.createTempFile("milton-zsync", "uploadData");
                fout = new FileOutputStream(uploadData);
                StreamUtils.readTo((InputStream)in, (OutputStream)fout);
                StreamUtils.close((OutputStream)fout);
                log.trace("Saved PUT data to " + uploadData.getAbsolutePath());
                File newFile = null;
                FileInputStream fin = null;
                BufferedInputStream uploadIn = null;
                try {
                    fin = new FileInputStream(uploadData);
                    uploadIn = new BufferedInputStream(fin);
                    UploadReader um = new UploadReader(prevFile, uploadIn);
                    newFile = um.assemble();
                    log.trace("Assembled file and saved to " + newFile.getAbsolutePath());
                    String actChecksum = new SHA1(newFile).SHA1sum();
                    String expChecksum = um.getChecksum();
                    if (!actChecksum.equals(expChecksum)) {
                        throw new RuntimeException("Computed SHA1 checksum doesn't match expected checksum\n\tExpected: " + expChecksum + "\n\tActual: " + actChecksum + "\n in temp file: " + newFile.getAbsolutePath());
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.close(uploadIn);
                    StreamUtils.close((InputStream)fin);
                    throw throwable;
                }
                StreamUtils.close((InputStream)uploadIn);
                StreamUtils.close((InputStream)fin);
                this.updateResourceContentActual(newFile);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMetaData(Map<String, String> params, String contentType, OutputStream out) throws RuntimeException {
            MetaFileMaker.MetaData metaData;
            Long fileLength = this.r.getContentLength();
            int blocksize = 512;
            if (fileLength != null) {
                blocksize = ZSyncResourceFactory.this.metaFileMaker.computeBlockSize(fileLength);
            }
            if (this.r instanceof ZSyncResource) {
                ZSyncResource zr = (ZSyncResource)this.r;
                metaData = zr.getZSyncMetaData();
            } else {
                BufferingOutputStream bufOut = new BufferingOutputStream(100000);
                try {
                    this.r.sendContent((OutputStream)bufOut, null, params, contentType);
                    bufOut.flush();
                }
                catch (Exception ex) {
                    bufOut.deleteTempFileIfExists();
                    throw new RuntimeException(ex);
                }
                finally {
                    StreamUtils.close((OutputStream)bufOut);
                }
                InputStream in = bufOut.getInputStream();
                try {
                    metaData = ZSyncResourceFactory.this.metaFileMaker.make(this.realPath, blocksize, fileLength == null ? 0L : fileLength, this.r.getModifiedDate(), in);
                }
                finally {
                    StreamUtils.close((InputStream)in);
                }
            }
            ZSyncResourceFactory.this.metaFileMaker.write(metaData, out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateResourceContentActual(File mergedFile) throws FileNotFoundException, BadRequestException, ConflictException, NotAuthorizedException, IOException {
            block6: {
                Resource rParent;
                String parentPath;
                block7: {
                    block5: {
                        if (!(this.r instanceof ReplaceableResource)) break block5;
                        log.trace("updateResourceContentActual: " + mergedFile.getAbsolutePath() + ", resource is replaceable");
                        FileInputStream fin = null;
                        try {
                            fin = new FileInputStream(mergedFile);
                            ReplaceableResource rr = (ReplaceableResource)this.r;
                            rr.replaceContent((InputStream)fin, Long.valueOf(mergedFile.length()));
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(fin);
                            throw throwable;
                        }
                        StreamUtils.close((InputStream)fin);
                        break block6;
                    }
                    log.trace("updateResourceContentActual: " + mergedFile.getAbsolutePath() + ", resource is NOT replaceable, try to replace through parent");
                    parentPath = Path.path((String)this.realPath).getParent().toString();
                    rParent = ZSyncResourceFactory.this.wrapped.getResource(this.host, parentPath);
                    if (rParent == null) {
                        throw new RuntimeException("Failed to locate parent resource to update contents. parent: " + parentPath + " host: " + this.host);
                    }
                    if (!(rParent instanceof PutableResource)) break block7;
                    log.trace("found parent resource, implements PutableResource");
                    FileInputStream fin = null;
                    try {
                        fin = new FileInputStream(mergedFile);
                        PutableResource putable = (PutableResource)rParent;
                        putable.createNew(this.r.getName(), (InputStream)fin, Long.valueOf(mergedFile.length()), this.r.getContentType(null));
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(fin);
                        throw throwable;
                    }
                    StreamUtils.close((InputStream)fin);
                    break block6;
                }
                throw new RuntimeException("Tried to update non-replaceable resource by doing createNew on parent, but the parent doesnt implement PutableResource. parent path: " + parentPath + " host: " + this.host + " parent type: " + rParent.getClass());
            }
        }

        public Long getMaxAgeSeconds(Auth auth) {
            return null;
        }

        public String getContentType(String accepts) {
            return "application/zsyncM";
        }

        public Long getContentLength() {
            return null;
        }

        public String getUniqueId() {
            return null;
        }

        public String getName() {
            return ZSyncResourceFactory.this.suffix;
        }

        public Object authenticate(String user, String password) {
            if (this.r == null) {
                return "ok";
            }
            return this.r.authenticate(user, password);
        }

        public boolean authorise(Request request, Request.Method method, Auth auth) {
            if (this.r == null) {
                return true;
            }
            return this.r.authorise(request, method, auth);
        }

        public String getRealm() {
            if (this.r == null) {
                return "Realm";
            }
            return this.r.getRealm();
        }

        public Date getModifiedDate() {
            if (this.r == null) {
                return null;
            }
            return this.r.getModifiedDate();
        }

        public String checkRedirect(Request request) {
            return null;
        }

        public Object authenticate(DigestResponse digestRequest) {
            return ((DigestResource)this.r).authenticate(digestRequest);
        }

        public boolean isDigestAllowed() {
            return this.r instanceof DigestResource && ((DigestResource)this.r).isDigestAllowed();
        }

        private void sendRangeData(OutputStream out) {
            PrintWriter pw = new PrintWriter(out);
            for (Range range : this.ranges) {
                pw.println(range.getRange());
            }
            pw.flush();
        }
    }
}

