/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.Host;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.StreamReceiver;
import io.milton.httpclient.TransferService;
import io.milton.httpclient.Utils;
import io.milton.httpclient.zsyncclient.FileSyncer;
import io.milton.httpclient.zsyncclient.HttpRangeLoader;
import io.milton.httpclient.zsyncclient.RangeLoader;
import io.milton.zsync.FileMaker;
import io.milton.zsync.UploadMaker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZSyncClient
implements FileSyncer {
    private static final Logger log = LoggerFactory.getLogger(ZSyncClient.class);
    private final TransferService transferService;
    private final FileMaker fileMaker;
    private int blocksize = 256;

    public ZSyncClient(TransferService transferService) {
        this.transferService = transferService;
        this.fileMaker = new FileMaker();
    }

    @Override
    public File download(Host host, Path remotePath, File localFile, final ProgressListener listener) throws IOException, NotFoundException, HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException, ConflictException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"download", host, remotePath});
        final File fRemoteMeta = File.createTempFile("zsync-meta", remotePath.getName());
        String url = host.getHref(remotePath.child(".zsync"));
        boolean notExisting = false;
        try {
            this.transferService.get(url, new StreamReceiver(){

                @Override
                public void receive(InputStream in) throws IOException {
                    if (listener != null && listener.isCancelled()) {
                        throw new Utils.CancelledException();
                    }
                    FileOutputStream fout = null;
                    try {
                        fout = new FileOutputStream(fRemoteMeta);
                        Utils.writeBuffered(in, fout, listener);
                    }
                    catch (Utils.CancelledException cancelled) {
                        throw cancelled;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                }
            }, null, listener, null);
        }
        catch (BadRequestException e) {
            notExisting = true;
        }
        io.milton.httpclient.File remoteFile = (io.milton.httpclient.File)host.find(remotePath.toString());
        if (notExisting) {
            throw new NotFoundException(url);
        }
        HttpRangeLoader rangeLoader = new HttpRangeLoader(remoteFile, listener);
        try {
            return this.fileMaker.make(localFile, fRemoteMeta, (RangeLoader)rangeLoader);
        }
        catch (Exception e) {
            if (e instanceof Utils.CancelledException) {
                throw (Utils.CancelledException)e;
            }
            if (e instanceof HttpException) {
                throw (HttpException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(Host host, File localcopy, Path remotePath, final ProgressListener listener) throws IOException, NotFoundException, Utils.CancelledException, NotAuthorizedException, ConflictException {
        final File fRemoteMeta = File.createTempFile("zsync", remotePath.getName());
        String baseUrl = host.getHref(remotePath);
        String url = baseUrl + "/.zsync";
        try {
            this.transferService.get(url, new StreamReceiver(){

                @Override
                public void receive(InputStream in) throws IOException {
                    FileOutputStream fout = new FileOutputStream(fRemoteMeta);
                    Utils.writeBuffered(in, fout, listener);
                }
            }, null, listener, null);
        }
        catch (BadRequestException e) {
            throw new NotFoundException(url);
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        UploadMaker umx = new UploadMaker(localcopy, fRemoteMeta);
        InputStream uploadIn = null;
        try {
            uploadIn = umx.makeUpload();
            this.transferService.put(url, uploadIn, null, null, null, listener, null);
        }
        finally {
            IOUtils.closeQuietly((InputStream)uploadIn);
            FileUtils.deleteQuietly((File)fRemoteMeta);
        }
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public void setBlocksize(int blocksize) {
        this.blocksize = blocksize;
    }
}

