/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.StreamUtils;
import io.milton.zsync.ChecksumPair;
import io.milton.zsync.Configuration;
import io.milton.zsync.Generator;
import io.milton.zsync.JarsyncProvider;
import io.milton.zsync.MakeContext;
import io.milton.zsync.MetaFileReader;
import io.milton.zsync.Rsum;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMatcher {
    private static final Logger log = LoggerFactory.getLogger(MapMatcher.class);
    private final Generator gen = new Generator();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double mapMatcher(File inputFile, MetaFileReader mfr, MakeContext mc) {
        double d;
        int bufferOffset = 0;
        FileInputStream is = null;
        long fileLength = inputFile.length();
        try {
            is = new FileInputStream(inputFile);
            BufferedInputStream inBuf = new BufferedInputStream(is);
            Security.addProvider(new JarsyncProvider());
            Configuration config = new Configuration();
            config.strongSum = MessageDigest.getInstance("MD4");
            config.weakSum = new Rsum();
            config.blockLength = mfr.getBlocksize();
            config.strongSumLength = mfr.getChecksumBytes();
            byte[] backBuffer = new byte[mfr.getBlocksize()];
            byte[] blockBuffer = new byte[mfr.getBlocksize()];
            int mebiByte = 0x100000;
            byte[] fileBuffer = mfr.getLength() < (long)mebiByte && (long)mfr.getBlocksize() < mfr.getLength() ? new byte[(int)mfr.getLength()] : ((long)mfr.getBlocksize() > mfr.getLength() || mfr.getBlocksize() > mebiByte ? new byte[mfr.getBlocksize()] : new byte[mebiByte]);
            boolean firstBlock = true;
            int len = fileBuffer.length;
            boolean end = false;
            int blocksize = mfr.getBlocksize();
            long lastMatch = 0L;
            while (mc.fileOffset != fileLength) {
                boolean match;
                byte[] strongSum;
                int weakSum;
                int n = ((InputStream)inBuf).read(fileBuffer, 0, len);
                if (firstBlock) {
                    weakSum = this.gen.generateWeakSum(fileBuffer, 0, config);
                    bufferOffset = mfr.getBlocksize();
                    int weak = this.updateWeakSum(weakSum, mfr);
                    if (this.hashLookUp(weak, null, blocksize, mc)) {
                        strongSum = this.gen.generateStrongSum(fileBuffer, 0, blocksize, config);
                        match = this.hashLookUp(this.updateWeakSum(weakSum, mfr), strongSum, blocksize, mc);
                        if (match) {
                            lastMatch = mc.fileOffset;
                        }
                    }
                    ++mc.fileOffset;
                    firstBlock = false;
                }
                while (bufferOffset < fileBuffer.length) {
                    int wSum;
                    byte newByte = fileBuffer[bufferOffset];
                    if (mc.fileOffset + (long)mfr.getBlocksize() > fileLength) {
                        newByte = 0;
                    }
                    weakSum = this.gen.generateRollSum(newByte, config);
                    boolean found = false;
                    if (mc.fileOffset >= lastMatch + (long)blocksize && this.hashLookUp(wSum = this.updateWeakSum(weakSum, mfr), null, blocksize, mc)) {
                        found = true;
                    }
                    if (found) {
                        if (mc.fileOffset + (long)mfr.getBlocksize() > fileLength) {
                            if (n > 0) {
                                Arrays.fill(fileBuffer, n, fileBuffer.length, (byte)0);
                            } else {
                                int offset = fileBuffer.length - mfr.getBlocksize() + bufferOffset + 1;
                                System.arraycopy(fileBuffer, offset, blockBuffer, 0, fileBuffer.length - offset);
                                Arrays.fill(blockBuffer, fileBuffer.length - offset, blockBuffer.length, (byte)0);
                            }
                        }
                        if (bufferOffset - mfr.getBlocksize() + 1 < 0) {
                            if (n > 0) {
                                System.arraycopy(backBuffer, backBuffer.length + bufferOffset - mfr.getBlocksize() + 1, blockBuffer, 0, mfr.getBlocksize() - bufferOffset - 1);
                                System.arraycopy(fileBuffer, 0, blockBuffer, mfr.getBlocksize() - bufferOffset - 1, bufferOffset + 1);
                            }
                            strongSum = this.gen.generateStrongSum(blockBuffer, 0, blocksize, config);
                            match = this.hashLookUp(this.updateWeakSum(weakSum, mfr), strongSum, blocksize, mc);
                            if (match) {
                                lastMatch = mc.fileOffset;
                            }
                        } else {
                            strongSum = this.gen.generateStrongSum(fileBuffer, bufferOffset - blocksize + 1, blocksize, config);
                            match = this.hashLookUp(this.updateWeakSum(weakSum, mfr), strongSum, blocksize, mc);
                            if (match) {
                                lastMatch = mc.fileOffset;
                            }
                        }
                    }
                    ++mc.fileOffset;
                    if (mc.fileOffset == fileLength) {
                        end = true;
                        break;
                    }
                    ++bufferOffset;
                }
                System.arraycopy(fileBuffer, fileBuffer.length - mfr.getBlocksize(), backBuffer, 0, mfr.getBlocksize());
                bufferOffset = 0;
                if (!end) continue;
            }
            double complete = this.matchControl(mfr, mc);
            mc.removematch(mc.blockcount() - 1);
            ((InputStream)is).close();
            d = complete;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
                catch (NoSuchAlgorithmException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(is);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)is);
        return d;
    }

    private int updateWeakSum(int weak, MetaFileReader mfr) {
        byte[] rsum;
        switch (mfr.getRsumBytes()) {
            case 2: {
                rsum = new byte[]{0, 0, (byte)(weak >> 24), (byte)(weak << 8 >> 24)};
                break;
            }
            case 3: {
                rsum = new byte[]{(byte)(weak << 8 >> 24), 0, (byte)(weak << 24 >> 24), (byte)(weak >> 24)};
                break;
            }
            case 4: {
                rsum = new byte[]{(byte)(weak >> 24), (byte)(weak << 8 >> 24), (byte)(weak << 16 >> 24), (byte)(weak << 24 >> 24)};
                break;
            }
            default: {
                rsum = new byte[4];
            }
        }
        int weakSum = 0;
        weakSum += (rsum[0] & 0xFF) << 24;
        weakSum += (rsum[1] & 0xFF) << 16;
        weakSum += (rsum[2] & 0xFF) << 8;
        return weakSum += rsum[3] & 0xFF;
    }

    private boolean hashLookUp(int weakSum, byte[] strongSum, int blocksize, MakeContext mc) {
        if (strongSum == null) {
            ChecksumPair p = new ChecksumPair(weakSum);
            ChecksumPair link = mc.hashtable.find(p);
            if (link != null) {
                return true;
            }
        } else {
            ChecksumPair p = new ChecksumPair(weakSum, strongSum);
            ChecksumPair link = mc.hashtable.findMatch(p);
            if (link != null) {
                int seq = link.getSequence();
                mc.put(seq, mc.fileOffset);
                mc.delete(new ChecksumPair(weakSum, strongSum, blocksize * seq, blocksize, seq));
                return true;
            }
        }
        return false;
    }

    private double matchControl(MetaFileReader mfr, MakeContext mc) {
        int missing = 0;
        int blockCount = mc.blockcount();
        for (int i = 0; i < blockCount; ++i) {
            if (mfr.getSeqNum() == 2) {
                if (i > 0 && i < blockCount - 1) {
                    if (!mc.matched(i - 1) && !mc.matched(i + 1)) {
                        mc.removematch(i);
                    }
                } else if (i == 0) {
                    if (!mc.matched(i + 1)) {
                        mc.removematch(i);
                    }
                } else if (i == blockCount - 1 && !mc.matched(i - 1)) {
                    mc.removematch(i);
                }
            }
            if (mc.matched(i)) continue;
            ++missing;
        }
        log.trace("matchControl: fileMap.length: " + blockCount + " - missing: " + missing);
        return ((double)blockCount - (double)missing) / (double)blockCount * 100.0;
    }
}

