/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.RangeUtils;
import io.milton.common.StreamUtils;
import io.milton.http.Range;
import io.milton.httpclient.zsyncclient.RangeLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class LocalFileRangeLoader
implements RangeLoader {
    private final File file;
    private long bytesDownloaded;

    public LocalFileRangeLoader(File file) {
        this.file = file;
    }

    @Override
    public byte[] get(List<Range> rangeList) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (Range r : rangeList) {
            this.writeRange(r, bout);
        }
        byte[] bytes = bout.toByteArray();
        return bytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeRange(Range r, ByteArrayOutputStream bout) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.file);
            BufferedInputStream bufIn = new BufferedInputStream(fin);
            this.bytesDownloaded += r.getFinish() - r.getStart();
            RangeUtils.writeRange((InputStream)bufIn, (Range)r, (OutputStream)bout);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new RuntimeException(ex);
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(fin);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)fin);
    }

    public long getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    public static int calcExpectedLength(List<Range> rangeList) {
        int l = 0;
        for (Range r : rangeList) {
            l = (int)((long)l + (r.getFinish() - r.getStart()));
        }
        return l;
    }
}

