/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.common.Path;
import io.milton.common.Utils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.httpclient.File;
import io.milton.httpclient.Folder;
import io.milton.httpclient.Host;
import io.milton.httpclient.HttpException;
import io.milton.httpclient.ProgressListener;
import io.milton.httpclient.PropFindResponse;
import io.milton.httpclient.ResourceListener;
import io.milton.httpclient.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    public Folder parent;
    public String name;
    public String displayName;
    private Date modifiedDate;
    private Date createdDate;
    final List<ResourceListener> listeners = new ArrayList<ResourceListener>();
    private String lockOwner;
    private String lockToken;
    private static long count = 0L;

    static Resource fromResponse(Folder parent, PropFindResponse resp, Map<Folder, List<Resource>> cache) {
        if (resp.isCollection()) {
            return new Folder(parent, resp, cache);
        }
        return new File(parent, resp);
    }

    public static String decodePath(String href) {
        href = href.replace("[", "%5B").replace("]", "%5D");
        href = href.replace(" ", "%20");
        href = href.replace("{", "%7B").replace("}", "%7D");
        try {
            if (href.startsWith("/")) {
                URI uri = new URI("http://anything.com" + href);
                return uri.getPath();
            }
            URI uri = new URI("http://anything.com/" + href);
            String s = uri.getPath();
            return s.substring(1);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract java.io.File downloadTo(java.io.File var1, ProgressListener var2) throws FileNotFoundException, IOException, HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException;

    public static long getCount() {
        return count;
    }

    public abstract String encodedUrl();

    Resource() {
        this.parent = null;
        this.name = "";
        this.displayName = "";
        this.createdDate = null;
        this.modifiedDate = null;
        ++count;
    }

    public Resource(Folder parent, PropFindResponse resp) {
        ++count;
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        this.parent = parent;
        this.name = Resource.decodePath(resp.getName());
        this.displayName = resp.getDisplayName();
        this.createdDate = resp.getCreatedDate();
        this.modifiedDate = resp.getModifiedDate();
        if (resp.getLock() != null) {
            this.lockToken = resp.getLock().getToken();
            this.lockOwner = resp.getLock().getOwner();
        } else {
            this.lockToken = null;
            this.lockOwner = null;
        }
    }

    public Resource(Folder parent, String name, String displayName, String href, Date modifiedDate, Date createdDate) {
        ++count;
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
        this.name = name;
        this.displayName = displayName;
        this.modifiedDate = modifiedDate;
        this.createdDate = createdDate;
    }

    public Resource(Folder parent, String name) {
        ++count;
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
        this.name = name;
        this.displayName = name;
        this.modifiedDate = null;
        this.createdDate = null;
    }

    protected void finalize() throws Throwable {
        --count;
        super.finalize();
    }

    public void addListener(ResourceListener l) {
        this.listeners.add(l);
    }

    public String post(Map<String, String> params) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        return this.host().doPost(this.encodedUrl(), params);
    }

    public void lock() throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.lock(-1);
    }

    public void lock(int timeout) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        if (this.lockToken != null) {
            log.warn("already locked: " + this.href() + " token: " + this.lockToken);
        }
        try {
            this.lockToken = this.host().doLock(this.encodedUrl(), timeout);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int unlock() throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        if (this.lockToken == null) {
            throw new IllegalStateException("Can't unlock, is not currently locked (no lock token) - " + this.href());
        }
        try {
            return this.host().doUnLock(this.encodedUrl(), this.lockToken);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void copyTo(Folder folder) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.copyTo(folder, this.name);
    }

    public void copyTo(Folder folder, String destName) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        try {
            this.host().doCopy(this.encodedUrl(), folder.encodedUrl() + Utils.percentEncode((String)destName));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        folder.flush();
    }

    public void rename(String newName) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        int res;
        String dest = "";
        if (this.parent != null) {
            dest = this.parent.encodedUrl();
        }
        dest = dest + Utils.percentEncode((String)newName);
        try {
            res = this.host().doMove(this.encodedUrl(), dest);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (res == 201) {
            this.name = newName;
        }
    }

    public void moveTo(Folder folder) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.moveTo(folder, this.name);
    }

    public void moveTo(Folder folder, String destName) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        int res;
        log.info("Move: " + this.href() + " to " + folder.href());
        try {
            res = this.host().doMove(this.encodedUrl(), folder.href() + Utils.percentEncode((String)destName));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (res == 201) {
            this.parent.flush();
            folder.flush();
        }
    }

    public void removeListener(ResourceListener l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return this.href() + "(" + this.displayName + ")";
    }

    public void delete() throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.host().doDelete(this.encodedUrl());
        this.notifyOnDelete();
    }

    void notifyOnDelete() {
        if (this.parent != null) {
            this.parent.notifyOnChildRemoved(this);
        }
        ArrayList<ResourceListener> l2 = new ArrayList<ResourceListener>(this.listeners);
        for (ResourceListener l : l2) {
            l.onDeleted(this);
        }
    }

    public Host host() {
        Host h = this.parent.host();
        if (h == null) {
            throw new NullPointerException("no host");
        }
        return h;
    }

    public String encodedName() {
        return Utils.percentEncode((String)this.name);
    }

    public String href() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.href() + this.name;
    }

    public Path path() {
        if (this.parent == null) {
            return Path.root;
        }
        return this.parent.path().child(this.name);
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }
}

