/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.httpclient.Host;
import io.milton.httpclient.PropFindMethod;
import io.milton.httpclient.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMethod
extends HttpEntityEnclosingRequestBase {
    private static final Logger log = LoggerFactory.getLogger(PropFindMethod.class);

    public ReportMethod(String uri) throws URISyntaxException {
        this.setURI(new URI(uri));
    }

    public String getMethod() {
        return "REPORT";
    }

    public Document getResponseAsDocument(HttpClient client, HttpContext context) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Utils.executeHttpWithStatus(client, (HttpUriRequest)this, out, context);
        String xml = out.toString();
        try {
            Document document = Host.getJDomDocument(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            return document;
        }
        catch (JDOMException ex) {
            throw new RuntimeException(xml, ex);
        }
    }
}

